<?php
/**
 * This generates the Javascript needed for jQTR.
 * It stores a copy of the generated JS in the options-table of Wordpress.
 * You can force a refresh of the whole source by appending ?jQTR_refresh=1
 * to the js-call
 *
 */
if (empty($_REQUEST['path']))
	return;

header("Content-type: application/x-javascript");


$dir = substr($_SERVER['SCRIPT_FILENAME'], 0,
	strrpos($_SERVER['SCRIPT_FILENAME'],'wp-content'));

if (empty($wp)) {
	require_once($dir . 'wp-config.php');
}

$path = substr($_SERVER['SCRIPT_FILENAME'], 0,
	strrpos($_SERVER['SCRIPT_FILENAME'],'/')) . "/" . str_replace("../", "", $_REQUEST['path']);

/* maybe we have already all the javascript */
$chartreetext = get_option('jQTR_chartree_' . str_replace("../", "", $_REQUEST['path']));
if ( !empty($chartreetext) && !$_GET['jQTR_refresh']) {
	echo stripslashes($chartreetext);
	return;
}

if (! is_dir($path))
	return;
$dir = opendir($path);
if ( empty($dir)) return;

/* we cache the whole thing */
echo '
/* generating new version */';

function tk32_generate_chartree($string, &$chartree) {
	$letter = substr($string, 0, 1);
	if (strlen($string) >= 1) {
		tk32_generate_chartree(substr($string, 1), $chartree[$letter]);
	} else {
		if ( empty($chartree[$letter]))
			$chartree[$letter]['endnode'] == true;
	}
}

function tk32_chartree2javascript($text, &$chartree, &$done = Array()) {
	if ( ! is_array($chartree))
		return;
	if ( ! is_array($done))
		$done = Array();
	foreach ($chartree as $node => &$subtree) {
		if ( !in_array($node, $done)) {
			echo $text, "['$node'] = new Object();
";
		}
		if (count($chartree) != 1) {
			if ( !empty($subtree)) {
				echo $text, "['$node']['end'] = true;
";
			}
			tk32_chartree2javascript($text . "['$node']", $subtree, $done[$node]);
		} else if ( empty($subtree['endnode']))
			tk32_chartree2javascript($text . "['$node']", $subtree, $done[$node]);
		unset($subtree);
	}
}


ob_start();

echo '
/* automatically generated via PHP for JQuery Text Replacment */
/* generated new version at ', date('l dS of F Y h:i:s A'), ' */

var chartree = new Object();

';

$chartree = Array();

while ($file = readdir()) {
	if (substr($file, 0, 1) == "." || ! in_array(substr($file, -3), Array('png', 'gif', 'jpg')))
		continue;
	$word = substr($file, 0, -4);
	tk32_generate_chartree($word, &$chartree, (count($chartree) == 1));
	
}

$done = Array();
$text = "chartree";
tk32_chartree2javascript($text, $chartree, $done);



update_option('jQTR_chartree_' . str_replace("../", "", $_REQUEST['path']), ob_get_contents());
ob_flush();
?>