﻿/*
 *
 * Copyright (c) 2006/2007 Sam Collett (http://www.texotela.co.uk)
 * Copyright (c) 2007 Thomas R. "TomK32" Koll; http://blog.tomk32.de
 * Licensed under the MIT License:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * Version: 1.1
 *
 * Changelog
 *   v1.1
 *   - added support for charmap-tree
 *   - changed name to jQueryTextReplace (jQTR) to avoid conflicts when both 
 *     versions are running
 */

 
 
 

/*
 * jQuery Image Replacement. An alternative to using CSS hacks
 * The text of an element will be replaced by images.
 * For replacement a chartree can be defined which allows individual kerning
 * or special things like 1st or common words like "blog" to be a single image
 * An alternative to define an image in the class-attribute is possible.
 * @name     jQIR
 * @param    format  Image format/file extension (e.g. png, gif, jpg) - ignored if specifying the filename in the class
 * @param    path    Path to images folder (optional)
 * @param    chartree A deep Object containing a tree with nodes of single letter
 * @author   Sam Collett (http://www.texotela.co.uk)
 * @example  $(".jqir").jQIR("png", "images/");
 * @before   <h1 class="jqtr">Heading 1</h1>
 *           <h2 class="jqir {src:heading2.png}">Heading 2</h2>
 * @result   <h1 class="jqir"><img alt="H" src="images/H.png"><img alt="e" src="images/e.png"><img alt="a" src="images/a.png"><img alt="d" src="images/d.png"><img alt="i" src="images/i.png"><img alt="n" src="images/n.png"><img alt="g" src="images/g.png"><img alt="%20" src="images/%20.png"><img alt="1" src="images/1.png"></h1>   
 *           <h2 class="jqir {src:heading2.png}"><img alt="Heading 2" src="images/heading2.png"></h2>   
 *
 */
jQuery.fn.jQTR = function(format, path, chartree) {


	// we require a chartree, sorry I don't want to default anything
	if ( typeof chartree == 'undefined')
		return;

	if(!document.images) return this;
	path = path || "";

	this.each(
		function()
		{
			var img = $("<img>"), self = jQuery(this);
			var file;
			var re = /(?:{src\:)(\S+)(?:})/i;
			var m = this.className.match(re);
			if(m)
			{
				file = path + m[1];
				jQuery(img).attr({ src: file, alt: self.text() });
				self.empty().append(img);
			}
			else
			{
				var text = $(this).text();
				$(this).empty();
				var words = Array();
				
				for (var c=0; c < text.length; c++) {
					var word = jQuery.fn.jQTR.getPath(chartree, text.substring(c));
					if (typeof word != "string" || word.length < 1) {
						word = text.substring(c, c+1);
					} else {
						if (word.length > 1)
							c = c + word.length - 1;
					}
					words.push(word);
					word = "";
					
				}
				for (var d=0; d < words.length; d++) {
					file = path + words[d] + "." + format;
					if (typeof words[d] == "Object")
						$(this).append(words[d].toString());
					else
						$(this).append('<img src="' + file + '" alt="' + words[d] + '" />');
				}
			}
		}
	)
	return this;
}


jQuery.fn.jQTR.getPath = function(chartree, needle) {

	var letter = needle.substring(0,1);
	
	if ( typeof chartree[letter] == "object") {
		var path = jQuery.fn.jQTR.getPath(chartree[letter], needle.substring(1));
		if (path != null)
			return letter + path;
		else {
			if (typeof chartree[letter]['end'] != "undefined") {
				$("#footer").append('HIT');
				return letter;
			} else {
				return null;
			}
		}
	} else // we are the end of a path, sadly the type is 
	       //undefined instead of object. damn you Javascript!
		return "";
}
