<?php get_header(); ?>

<?php if (have_posts()) : ?>

<?php $post = $posts[0]; // Hack. Set $post so that the_date() works. ?>

<?php /* If this is a category archive */ if (is_category()) { ?>
<h2>Archive for the &#8220;<?php echo single_cat_title(); ?>&#8221; category</h2>
<p class="info">You are currently browsing the <a href="<?php echo get_settings('siteurl'); ?>" title="<?php echo bloginfo('name'); ?>"><?php echo bloginfo('name'); ?></a> archives for the <cite><?php single_cat_title(''); ?></cite> category.</p>
<?php /* If this is a daily archive */ } elseif (is_day()) { ?>
<h2>Archive for <?php the_time('F jS, Y'); ?></h2>
<p class="info">You are currently browsing the <a href="<?php echo get_settings('siteurl'); ?>" title="<?php echo bloginfo('name'); ?>"><?php echo bloginfo('name'); ?></a> archives for the day <?php the_time('l, F jS, Y'); ?>.</p>
<?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
<h2>Archive for <?php the_time('F, Y'); ?></h2>
<p class="info">You are currently browsing the <a href="<?php echo get_settings('siteurl'); ?>" title="<?php echo bloginfo('name'); ?>"><?php echo bloginfo('name'); ?></a> archives for <?php the_time('F, Y'); ?>.</p>
<?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
<h2>Archive for <?php the_time('Y'); ?></h2>
<p class="info">You are currently browsing the <a href="<?php echo get_settings('siteurl'); ?>" title="<?php echo bloginfo('name'); ?>"><?php echo bloginfo('name'); ?></a> archives for the year <?php the_time('Y'); ?>.</p>
<?php /* If this is an author archive */ } elseif (is_author()) { ?>
<h2>Author Archive</h2>
<p class="info">You are currently viewing the posts made by <?php the_author(); ?>.</p>
<?php /* If this is a paged archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
<h2>Blog Archives</h2>
<p class="info">You are currently browsing the <a href="<?php echo get_settings('siteurl'); ?>" title="<?php echo bloginfo('name'); ?>"><?php echo bloginfo('name'); ?></a> archives.</p>
<?php } ?>

<?php while (have_posts()) : the_post(); ?>
<h3><a href="<?php the_permalink() ?>" title="Permanent link to <?php the_title(); ?>" rel="bookmark"><?php the_title(); ?></a></h3>
<small><?php the_time('l, F jS, Y') ?></small>

<?php the_content('View this post in full&#8230;'); ?>
		
<p class="meta">Posted in <?php the_category(', ') ?> <strong>|</strong> <?php edit_post_link('Edit','','<strong>|</strong>'); ?> <?php comments_popup_link('Comments (0)', 'Comments (1)', 'Comments (%)'); ?></p>

<!--
<?php trackback_rdf(); ?>
-->

<?php endwhile; ?>

<?php else : ?>

<h2>Whoops</h2>

<p>You&#8217;re looking for something that isn&#8217;t here. You can try a search using the form below, or <a href="<?php echo get_settings('siteurl'); ?>" title="<?php echo bloginfo('name'); ?>">return to the main page</a> and start looking from there.</p>

<?php include (TEMPLATEPATH . '/in-page-searchform.php'); ?>

<?php endif; ?>

<?php get_footer(); ?>