function createElement(element) {
	if (typeof document.createElementNS != 'undefined') {
		return document.createElementNS('http://www.w3.org/1999/xhtml', element);
		}
	if (typeof document.createElement != 'undefined') {
		return document.createElement(element);
		}
	return false;
}

// smooth scrolling

function ss_fixAllLinks() {
	var allLinks = document.getElementsByTagName('a');
	for (var i=0;i<allLinks.length;i++)
		{
		var lnk = allLinks[i];
		if ((lnk.href && lnk.href.indexOf('#') != -1) && 
		( (lnk.pathname == location.pathname) ||
		('/'+lnk.pathname == location.pathname) ) && 
		(lnk.search == location.search))
			{
			ss_addEvent(lnk,'click',smoothScroll);
			}
		}
	}
function smoothScroll(e) {
	if (window.event) {
		target = window.event.srcElement;
		}
	else if (e) {
		target = e.target;
		}
	else return;
	anchor = target.hash.substr(1);
	destinationLink = document.getElementById(anchor);
	if (!destinationLink) return true;
	var destx = destinationLink.offsetLeft; 
	var desty = destinationLink.offsetTop;
	var thisNode = destinationLink;
	while (thisNode.offsetParent && 
	(thisNode.offsetParent != document.body)) {
		thisNode = thisNode.offsetParent;
		destx += thisNode.offsetLeft;
		desty += thisNode.offsetTop;
		}
	clearInterval(ss_INTERVAL);
	cypos = ss_getCurrentYPos();
	ss_stepsize = parseInt((desty-cypos)/ss_STEPS);
	ss_INTERVAL = setInterval('ss_scrollWindow('+ss_stepsize+','+desty+',"'+anchor+'")',10);
	if (window.event) {
		window.event.cancelBubble = true;
		window.event.returnValue = false;
		}
	if (e && e.preventDefault && e.stopPropagation) {
		e.preventDefault();
		e.stopPropagation();
		}
	}
function ss_scrollWindow(scramount,dest,anchor) {
	wascypos = ss_getCurrentYPos();
	isAbove = (wascypos < dest);
	window.scrollTo(0,wascypos + scramount);
	iscypos = ss_getCurrentYPos();
	isAboveNow = (iscypos < dest);
	if ((isAbove != isAboveNow) || (wascypos == iscypos))
		{
		window.scrollTo(0,dest);
		clearInterval(ss_INTERVAL);
		location.hash = anchor;
		}
	}
function ss_getCurrentYPos() {
	if (document.body && document.body.scrollTop)
	return document.body.scrollTop;
	if (document.documentElement && document.documentElement.scrollTop)
	return document.documentElement.scrollTop;
	if (window.pageYOffset)
	return window.pageYOffset;
	return 0;
	}
function ss_addEvent(elm, evType, fn, useCapture) {
	if (elm.addEventListener) {
		elm.addEventListener(evType, fn, useCapture);
		return true;
		}
	else if (elm.attachEvent) {
		var r = elm.attachEvent("on"+evType, fn);
		return r;
		}
	else {
		//alert("Handler could not be removed");
		}
	} 

var ss_INTERVAL;
var ss_STEPS = 15;

function bookmarkLinks(){
var a = document.getElementsByTagName("a");
	for(i=0; i<a.length; i++){
		if(a[i].getAttribute("rel") == "bookmark"){
			var linkelement = createElement("link");
			linkelement.setAttribute("rel","bookmark");
			linkelement.setAttribute("href",a[i].getAttribute("href"));
			linkelement.setAttribute("title",a[i].getAttribute("title"));
			document.getElementsByTagName("head")[0].appendChild(linkelement);
		}
	}
}

function textareaResizer() {
// http://mathibus.com/archives/2005/02/08/js-textarea-resizer/
	var labels = document.getElementsByTagName('label');
	for(i=0; i<labels.length; i++) {
		if(labels[i].getAttribute("for") == "comment") {
			enlarge = createElement('a');
			enlarge.setAttribute('style', 'cursor: pointer;');
			enlarge.onclick = function () { document.getElementById('comment').rows += 5; }
			enlarge.setAttribute('title', 'Click to enlarge the message textarea');
			enlarge.appendChild(document.createTextNode('Enlarge textarea \u2193'));
			decrease = createElement('a');
			decrease.setAttribute('style', 'cursor: pointer;');
			decrease.onclick = function () { document.getElementById('comment').rows -= 5; }
			decrease.setAttribute('title', 'Click to decrease the message textarea');
			decrease.appendChild(document.createTextNode('Decrease textarea \u2191'));

			small = createElement('small');
			small.appendChild(document.createTextNode(' ('));
			small.appendChild(enlarge);
			small.appendChild(document.createTextNode(' | '));
			small.appendChild(decrease);
			small.appendChild(document.createTextNode(')'));
			labels[i].appendChild(small);
		}
	}
}

// onload scripts

function runScripts() {
	ss_fixAllLinks();
	bookmarkLinks();
	textareaResizer();
	}

window.onload = runScripts;