<?php get_header(); ?>

<?php if (have_posts()) : ?>

<h2>Search Results</h2>

<p class="info">You have searched the <a href="<?php echo get_settings('siteurl'); ?>" title="<?php echo bloginfo('name'); ?>"><?php echo bloginfo('name'); ?></a> archives for <cite>&#8220;<?php echo wp_specialchars($s); ?>&#8220;</cite>. If you are unable to find anything in these search results, you can try one of these links.</p>
		
<?php while (have_posts()) : the_post(); ?>
				
<h3><a href="<?php the_permalink() ?>" title="Permanent link to <?php the_title(); ?>" rel="bookmark"><?php the_title(); ?></a></h3>
<small><?php the_time('l, F jS, Y') ?></small>

<?php the_excerpt(); ?>
	
<p class="info">Posted in <?php the_category(', ') ?> <strong>|</strong> <?php edit_post_link('Edit','','<strong>|</strong>'); ?>  <?php comments_popup_link('Comments (0)', 'Comments (1)', 'Comments (%)'); ?></p> 

<!--
<?php trackback_rdf(); ?>
-->

<?php endwhile; ?>

<?php else : ?>

<h2>Not Found</h2>

<p>Your search didn&#8217;t match any results. You can try another one using the form below, or go back to <a href="<?php echo get_settings('home'); ?>" title="<?php bloginfo('name'); ?>"><?php bloginfo('name'); ?></a>.</p>

<?php include (TEMPLATEPATH . '/searchform.php'); ?>

<?php endif; ?>
		
<?php get_footer(); ?>