<?php // Do not delete these lines

function grimelda_gravatar($rating = false, $size = false, $default = false, $border = false) {
	global $comment;
	if($comment->comment_author_email) {

		$out = "http://gravatar.com/avatar.php?gravatar_id=".md5($comment->comment_author_email);

		if($size && $size != '')
			$out .="&amp;size=".$size;
		if($default && $default != '')
			$out .= "&amp;default=".urlencode($default);
		if($border && $border != '')
			$out .= "&amp;border=".$border;
		echo '<dt class="gravatar"><img src="' . $out . '" width="' . $size . '" height="' . $size . '" alt="This commenter&#8217;s Gravatar" /></dt>';
	}
}

	if ('comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
		die ('Please do not load this page directly. Thanks!');

		if (!empty($post->post_password)) { // if there's a password
			if ($_COOKIE['wp-postpass_' . COOKIEHASH] != $post->post_password) {  // and it doesn't match the cookie
				?>
				
				<p><?php _e("This post is password protected. Enter the password to view comments."); ?><p>
				
				<?php
				return;
			}
		}

		/* This variable is for alternating comment background */
		$oddcomment = ' alt';
?>

<!-- You can start editing here. -->

<h3 id="comments"><a href="#comments" title="Permanent link for the comments on this post" rel="bookmark"><?php comments_number('Comments (0)', 'Comments (1)', 'Comments (%)' );?></a></h3>

<p>You can follow any responses to this entry through the <?php comments_rss_link('<acronym title="Rich Site Summary">RSS</acronym> 2.0'); ?> feed.
<?php if (('open' == $post-> comment_status) && ('open' == $post->ping_status)) {
	// Both Comments and Pings are open ?>
	You can <a href="#respond" title="Jump down to the comment form">leave a comment</a>, or <a href="<?php trackback_url(display); ?>" title="Grab the trackback URI for this entry">trackback</a> from your own site.
	<?php } elseif (!('open' == $post-> comment_status) && ('open' == $post->ping_status)) {
	// Only Pings are Open ?>
	Commenting has been disabled for this post, but you can <a href="<?php trackback_url(display); ?> " title="Grab the trackback URI for this entry">trackback</a> from your own site.
	<?php } elseif (('open' == $post-> comment_status) && !('open' == $post->ping_status)) {
	// Comments are open, Pings are not ?>
	You can skip to the end and <a href="#respond" title="Jump down to the comment form">leave a comment</a>. Pinging is currently not allowed.
	<?php } elseif (!('open' == $post-> comment_status) && !('open' == $post->ping_status)) {
	// Neither Comments, nor Pings are open ?>
	Both comments and pings are currently closed.
	<?php } ?>
</p>

<?php if ($comments) : ?>
<ol class="comment-list">

<?php foreach ($comments as $comment) : ?>

<li class="comment<?php echo $oddcomment; ?>" id="comment-<?php comment_ID(); ?>">
<dl>
<dt class="who"><?php comment_author_link(); ?></cite>:</dt>
<?php grimelda_gravatar('R', 20); ?>
<dd class="what"><?php if ($comment->comment_approved == '0') : ?><em>Your comment is awaiting moderation.</em><?php endif; ?><?php comment_text(); ?></dd>
<dd class="when"><cite><a href="#comment-<?php comment_ID(); ?>" title="Permanent link to this comment"><?php comment_type('Comment posted', 'Trackback made', 'Pingback made'); ?> on <?php comment_date('F jS, Y') ?> at <?php comment_time(); ?></a> <?php edit_comment_link('edit this',' | ',''); ?></cite></dd>
</dl>
</li>

<?php /* Changes every other comment to a different class */	
if (' alt' == $oddcomment) $oddcomment = '';
else $oddcomment = ' alt';

endforeach; /* end for each comment */ ?>
</ol>

<?php else : // this is displayed if there are no comments so far ?>

<?php if ('open' == $post-> comment_status) : ?> 
<p>No comments yet.</p>
<?php else : // if comments are closed ?>
<p>Commenting has been disabled for this post.</p>
<?php endif; ?>
<?php endif; ?>

<?php if ('open' == $post-> comment_status) : ?>

<h3 id="respond"><a href="#respond" title="Permanent link to the comment form for this post" rel="bookmark">Leave a Comment</a></h3>

<?php if (get_option('comment_registration') && !$user_ID) : ?>
<p>You must be <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?redirect_to=<?php the_permalink(); ?>" title="Log in">logged in</a> to post a comment.</p>
<?php else : ?>
<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">

<?php if ($user_ID ) : ?>
<p>Logged in as <a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a>. <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?action=logout" title="<?php _e('Log out of this account') ?>">Logout &raquo;</a></p>
<?php else: ?>

<dl>
<dt><label for="author">Name <small><?php if ($req) _e('(required)'); ?></small></label></dt>
<dd><input type="text" name="author" id="author" value="<?php echo $comment_author; ?>" size="30" tabindex="1" /></dd>

<dt><label for="email">Mail <small>(<?php if ($req) { ?>required, but <?php } ?>will not be published)</small></label></dt>
<dd><input type="text" name="email" id="email" value="<?php echo $comment_author_email; ?>" size="30" tabindex="2" /></dd>

<dt><label for="url">Website <small>(you will be linked)</small></label></dt>
<dd><input type="text" name="url" id="url" value="<?php echo $comment_author_url; ?>" size="30" tabindex="3" /></dd>

<?php endif; ?>

<dt><label for="comment">Your Comment</label></dt>
<dd><textarea name="comment" id="comment" cols="50" rows="10" tabindex="4"></textarea></dd>

<dd>The following <acronym title="eXtensible HyperText Markup Language">XHTML</acronym> is allowed: <code><?php echo allowed_tags(); ?></code></dd>

<dt class="hide">Submit</dt>
<dd><input type="hidden" name="comment_post_ID" value="<?php echo $id; ?>" />
<input name="submit" type="submit" id="submit" tabindex="5" value="Submit Comment" /></dd>
</dl>
<?php do_action('comment_form', $post->ID); ?>
</form>

<?php endif; // If registration required and not logged in ?>
<?php endif; // if you delete this the sky will fall on your head ?>