<?php

function grimelda_get_links_list($order = 'name', $hide_if_empty = 'obsolete') {
	global $wpdb;

	$order = strtolower($order);

	// Handle link category sorting
	if (substr($order, 0, 1) == '_') {
		$direction = ' DESC';
		$order = substr($order,1);
	}

	// if 'name' wasn't specified, assume 'id':
	$cat_order = ('name' == $order) ? 'cat_name' : 'cat_id';

	if (!isset($direction)) $direction = '';
	// Fetch the link category data as an array of hashesa
	$cats = $wpdb->get_results("
		SELECT DISTINCT link_category, cat_name, show_images, 
			show_description, show_rating, show_updated, sort_order, 
			sort_desc, list_limit
		FROM `$wpdb->links` 
		LEFT JOIN `$wpdb->linkcategories` ON (link_category = cat_id)
		WHERE link_visible =  'Y'
			AND list_limit <> 0
		ORDER BY $cat_order $direction ", ARRAY_A);

	// Display each category
	if ($cats) {
		foreach ($cats as $cat) {
			// Handle each category.
			// First, fix the sort_order info
			$orderby = $cat['sort_order'];
			$orderby = (bool_from_yn($cat['sort_desc'])?'_':'') . $orderby;
			// Display the category name
			echo '<h2 id="linkcat-' . $cat['link_category'] . '">' . $cat['cat_name'] . "</h2>\n<ul>\n";
			// Call get_links() with all the appropriate params
			get_links($cat['link_category'], "\t<li>", "</li>", "\n", bool_from_yn($cat['show_images']), $orderby, bool_from_yn($cat['show_description']), bool_from_yn($cat['show_rating']), $cat['list_limit'], bool_from_yn($cat['show_updated']));
			// Close the last category
			echo "</ul>\n";
		}
	}
}

function grimelda_list_pages($args = '') {
	parse_str($args, $r);
	if (!isset($r['depth'])) $r['depth'] = 0;
	if (!isset($r['show_date'])) $r['show_date'] = '';
	if (!isset($r['child_of'])) $r['child_of'] = 0;
	if (!isset($r['title_li']) ) $r['title_li'] = __('Pages');

	$pages = get_pages($args);
	if ($pages) :

	if ($r['title_li'])
		echo $r['title_li'] . "\n<ul>";
	$page_tree = array();
	foreach($pages as $page) {
		$page_tree[$page->ID]['title'] = $page->post_title;
		$page_tree[$page->ID]['name'] = $page->post_name;
		if (! empty($r['show_date'])) {
			if ('modified' == $r['show_date'])
				$page_tree[$page->ID]['ts'] = $page->time_modified;
			else
				$page_tree[$page->ID]['ts'] = $page->time_created;
		}

		$page_tree[$page->post_parent]['children'][] = $page->ID;
	}
	_page_level_out($r['child_of'], $page_tree, $r);
	if ($r['title_li'])
		echo '</ul>';
	endif;
}

?>
</div><!-- /content -->
<div id="sidebar">
<?php if(!is_search() && !is_404()) { ?>
<h2><label for="s">Search</label></h2>
<?php include (TEMPLATEPATH . '/sidesearch.php'); ?>
<?php } ?>

<!-- Author information is disabled per default. Uncomment and fill in your details if you want to use it.
<h2><?php // _e('Author'); ?></h2>
<p>A little something about you, the author. Nothing lengthy, just an overview.</p>
-->

<div class="fitts">
<?php grimelda_list_pages('title_li=<h2>' . __('Pages') . '</h2>'); ?>

<?php if(is_single()) { ?>
<h2>Post Navigation</h2>
<ul>
	<?php previous_post('<li>%</li>', '&#8592; Previous', 'no'); ?>
	<?php next_post('<li>%</li>', 'Next &#8594;', 'no'); ?>
</ul>
<?php } ?>

<?php if(!is_single() && !is_page() && !is_404()) { ?>
<h2>Page Navigation</h2>
<ul>
	<li><?php posts_nav_link("</li>\n\t<li>", 'Next &#8594;', '&#8592; Previous'); ?></li>
</ul>
<?php } ?>
<h2><?php _e('Archives'); ?></h2>
<ul>
<?php wp_get_archives('type=monthly'); ?>
</ul>

<h2><?php _e('Categories'); ?></h2>
<ul>
<?php list_cats(0, '', 'name', 'asc', '', 1, 0, 0, 1, 1, 1, 0,'','','','','') ?>
</ul>

<?php /* If this is the frontpage */ if (is_home() || is_page()) { ?>
<?php grimelda_get_links_list(); ?>

<h2>1337 d3516n0r2</h2>
<ul>
	<li><a href="http://mathibus.com/" title="Math Jazz">Mathias Bynens</a></li>
</ul>

<h2><?php _e('Meta'); ?></h2>
<ul>
<?php wp_register(); ?>
<li><?php wp_loginout(); ?></li>
<li><a href="http://validator.w3.org/check/referer" title="<?php _e('This page validates as XHTML 1.0 Transitional'); ?>"><?php _e('Valid <acronym title="eXtensible HyperText Markup Language">XHTML</acronym>'); ?></a></li>
<li><a href="http://gmpg.org/xfn/" title="XFN is fun"><acronym title="XHTML Friends Network">XFN</acronym></a></li>
<li><a href="http://wordpress.org/" title="<?php _e('Powered by WordPress, state-of-the-art semantic personal publishing platform.'); ?>">WordPress</a></li>
<?php wp_meta(); ?>
</ul>
<?php } ?>

</div><!-- /fitts -->
</div><!-- /sidebar -->

<div class="clear">&nbsp;</div>