<?php

/*
	Functions shared between Similar Posts, Recent Posts, Random Posts, and Recent Comments
	
	Version: 1.03

*/

function process_input($args){

	// Initially I used parse_str but it caused problems when arguments contained their own '='
	// ... this is my cut-down version...
	// $args is of the form 'key1=val1&key2=val2'
	//	should cope with 'key1=&key2=val2',
	//	and 'before=<li class="stuff">'
	
	if($args){
		// separate the arguments
		$arguments = explode("&", $args);
		foreach($arguments as $arg){
			if($arg){
				// find the position of the first '='
				$i = strpos($arg, '=');
				// if not a valid format ('key=value) we ignore it
				if ($i){
					$key = substr($arg, 0, $i);
					$val = substr($arg, $i+1); 
					$p[$key]=$val;
				}
			}
		}
	}
	
	// This complicated block is trying to cope with several conditions:
	//	if Similar Posts is installed it's options page should provide the defaults for all parameters
	//	but if it isn't we need to provide sensible defaults of our own AND let them be overridden 
	//	if arguments have been explicitly set
	// How we do that depends on whether a parameter can sensibly be blank, the range of values it can have, etc.
	
	
  	if (!isset($p['limit'])) $p['limit'] = stripslashes(get_option('spo_limit'));
	// a blank value needs changing to the default
	if (trim($p['limit'])=='') $p['limit'] = 5;
	
  	if (!isset($p['skip'])) $p['skip'] = stripslashes(get_option('spo_skip'));
	if (trim($p['skip'])=='') $p['skip'] = 0;
	
	if (!isset($p['excerpt_length'])) $p['excerpt_length'] = stripslashes(get_option('spo_excerpt_length'));
	if (trim($p['excerpt_length'])=='') $p['excerpt_length'] = 50;
	
	// more complex case... if we have a supplied parameter we accept its value. otherwise
  	if (!isset($p['before_title'])) {
		// otherwise we try looking it up from options
		$p['before_title'] = get_option('spo_before_title');
		// the value false means there was no default stored, so we supply one
		if ($p['before_title']===false) $p['before_title'] = '<li>'; 	
		// but if a value was stored we need to stripslashes which WordPress may have added
		else $p['before_title'] = stripslashes($p['before_title']);
	}
	
  	if (!isset($p['after_title'])) {
		$p['after_title'] = get_option('spo_after_title');
		if ($p['after_title']==false) $p['after_title'] = '</li>';
		else $p['after_title'] = stripslashes($p['after_title']);
	}
	
	// another case... if we have a supplied parameter we accept it for now, otherwise
  	if (!isset($p['trim_before'])) {
		// otherwise we try looking it up from options
		$p['trim_before'] = get_option('spo_trim_before');
		// the value false means there was no default stored, so we supply one -- NB 'false' and not false!
		if ($p['trim_before']===false) $p['trim_before'] = 'false';
	}
	// since this parameter can only have fixed values we make sure any accidental blanks are dealt with
	if (trim($p['trim_before'])=='') $p['trim_before'] = 'false';
	
  	if (!isset($p['before_excerpt'])) {
		$p['before_excerpt'] = get_option('spo_before_excerpt');
		if ($p['before_excerpt']==false) $p['before_excerpt'] = '<li>';
		else $p['before_excerpt'] = stripslashes($p['before_excerpt']);
	}
	
  	if (!isset($p['after_excerpt'])) {
		$p['after_excerpt'] = get_option('spo_after_excerpt');
		if ($p['after_excerpt']==false) $p['after_excerpt'] = '</li>';
		else $p['after_excerpt'] = stripslashes($p['after_excerpt']);
	}
	
  	if (!isset($p['excerpt_format'])) $p['excerpt_format'] = stripslashes(get_option('spo_excerpt_format'));
	if (trim($p['excerpt_format'])=='') $p['excerpt_format'] = 'char';
	
  	if (!isset($p['show_private'])) {
		$p['show_private'] = get_option('spo_show_private');
		if ($p['show_private']===false) $p['show_private'] = 'false';
	}
	if (trim($p['show_private'])=='') $p['show_private'] = 'false';
	
	if (!isset($p['show_excerpt'])) {
		$p['show_excerpt'] = get_option('spo_show_excerpt');
		if ($p['show_excerpt']===false) $p['show_excerpt'] = 'false';
	}
	if (trim($p['show_excerpt'])=='') $p['show_excerpt'] = 'false';
	
	if (!isset($p['ellipsis'])) {
		$p['ellipsis'] = get_option('spo_ellipsis');
		if ($p['ellipsis']===false) $p['ellipsis'] = 'false';
	}
	if (trim($p['ellipsis'])=='') $p['ellipsis'] = 'false';
	
	if (!isset($p['show_static'])) {
		$p['show_static'] = get_option('spo_show_static');
		if ($p['show_static']===false) $p['show_static'] = 'false';
	}
	if (trim($p['show_static'])=='') $p['show_static'] = 'false';
	
	if (!isset($p['none_text'])) $p['none_text'] = stripslashes(get_option('spo_none_text'));
	if (trim($p['none_text'])=='') $p['none_text'] = __('No Recent Posts');
	
	// another case ... if no parameter is supplied we look up the options
	if (!isset($p['excluded_cats'])) $p['excluded_cats'] = stripslashes(get_option('spo_excluded_cats'));
	// a blank value has to be translated to the internal code '9999'
	if (trim($p['excluded_cats'])=='') $p['excluded_cats'] = '9999';
	
	if (!isset($p['excluded_authors'])) $p['excluded_authors'] = stripslashes(get_option('spo_excluded_authors'));
	if (trim($p['excluded_authors'])=='') $p['excluded_authors'] = '9999';
	
	return $p;
	
}

function process_output($results, $p){
    
	$output = '';
    if ($results) {
		foreach ($results as $result) {
			$title = stripslashes(apply_filters('the_title', $result->post_title));
			$permalink = get_permalink($result->ID);
        	$post_content = strip_tags($result->post_content);
			$post_content = stripslashes($post_content);
        	$output .= stripslashes($p['before_title']) .'<a href="'. $permalink .'" rel="bookmark" title="'.__('Permanent Link: ') . $title . '">' . $title . '</a>' . $p['after_title'];
			if ($p['show_excerpt']=='true') {
				// grab a maximum number of characters
				$excerpt = substr($post_content, 0, $p['excerpt_length']);
				switch ($p['excerpt_format']) {
				case 'char':
					// in this, the default case, we don't need to trim the excerpt
					break;
				case 'word':
					// trim back to the last full word--NB if our excerpt ends on a word
					// boundary we still have to trim back to the previous white space
					// (the final 's' in the pattern makes sure we match newlines)
					preg_match('/^(.*)\s/s', $excerpt, $matches);
					//if we can't get a single full word we use the full excerpt
					// (we use $matches[1] because we don't want the white-space)
					if ($matches[1]) $excerpt = $matches[1];
					break;
				case 'sent':
					// trim back to the last full sentence--defined as ended by ',', '!', or '?'
					// (the final 's' in the pattern makes sure we match newlines)
					preg_match('/^(.*)[\.\!\?]\s/s', $excerpt, $matches);
					//if we can't get a single full sentence we use the full excerpt
					// (we use $matches[0] because we want the end-of-sentecne punctuation)
					if ($matches[0]) $excerpt = $matches[0];
					break;
				default:
					// in this, the default case, we don't need to trim the excerpt
				}
				if ($p['ellipsis'] == 'true') $excerpt = $excerpt.' ...';
				$output .= $p['before_excerpt'] . $excerpt . $p['after_excerpt'];
	    	}
		}
		if ($p['trim_before']=='true') $output = substr($output, strlen($p['before_title']));
		return $output;
	} else {
        return $p['before_title'].$p['none_text'].$p['after_title'];
	}
}

?>