<?php get_header(); ?>

	<div class="rightcontainer">

		<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

			<div id="welcome"><?php the_title(); ?></div>

			<div class="news"  id="post-<?php the_ID(); ?>">
				<?php the_content('<p class="serif">Read the rest of this entry &raquo;</p>'); ?>
				<?php link_pages('<p><strong>Pages:</strong> ', '</p>', 'number'); ?>

				<p class="postmetadata alt">
					<small>
						This entry was posted
						<?php /* This is commented, because it requires a little adjusting sometimes.
							You will need to download this plugin, and follow the instructions:
							http://binarybonsai.com/archives/2004/08/17/time-since-plugin/ */
							/* $entry_datetime = abs(strtotime($post->post_date) - (60*120)); echo time_since($entry_datetime); echo ' ago'; */ ?>
						on <?php the_time('l, F jS, Y') ?> at <?php the_time() ?>
						and is filed under <?php the_category(', ') ?>.
						You can follow any responses to this entry through the <?php comments_rss_link('RSS 2.0'); ?> feed.

						<?php if (('open' == $post-> comment_status) && ('open' == $post->ping_status)) {
							// Both Comments and Pings are open ?>
							You can <a href="#respond">leave a response</a>, or <a href="<?php trackback_url(true); ?>" rel="trackback">trackback</a> from your own site.

						<?php } elseif (!('open' == $post-> comment_status) && ('open' == $post->ping_status)) {
							// Only Pings are Open ?>
							Responses are currently closed, but you can <a href="<?php trackback_url(true); ?> " rel="trackback">trackback</a> from your own site.

						<?php } elseif (('open' == $post-> comment_status) && !('open' == $post->ping_status)) {
							// Comments are open, Pings are not ?>
							You can skip to the end and leave a response. Pinging is currently not allowed.

						<?php } elseif (!('open' == $post-> comment_status) && !('open' == $post->ping_status)) {
							// Neither Comments, nor Pings are open ?>
							Both comments and pings are currently closed.

						<?php } edit_post_link('Edit this entry.','',''); ?>

					</small>
				</p>
				<div class="navigation">
					<div class="left"><?php previous_post_link('&laquo; %link') ?></div>
					<div class="right"><?php next_post_link('%link &raquo;') ?></div>
				</div>
			</div>

			<?php comments_template(); ?>

		<?php endwhile; else: ?>

			<div id="welcome">Duh!</div>

			<div class="content">
					<p>Sorry, no posts matched your criteria.</p>
			</div>


		<?php endif; ?>

		<div class="content">
			<div class="block left">
				<?php if ( function_exists('dynamic_sidebar') && dynamic_sidebar('Bottom Bar Left Block') ) : else : ?>

					<div class="widget">
						<h2>Monthly Archives</h2>

						<ul>
							<?php wp_get_archives('type=monthly'); ?>
						</ul>
					</div>

				<?php endif; ?>

			</div>
			<div class="block right">
				<?php if ( function_exists('dynamic_sidebar') && dynamic_sidebar('Bottom Bar Right Block') ) : else : ?>

					<div class="widget">
						<h2>Categories</h2>
						<ul>
							<?php wp_list_cats('sort_column=name&hierarchical=0'); ?>
						</ul>
					</div>

				<?php endif; ?>
			</div>
		</div>

	</div>

<?php get_footer(); ?>
