<?php


//  title filter
function get_karma_title($content) {

	if (!$pos = strpos($content, ' ', 2)) {
		$pos = strlen($content);
	}

	$content = substr_replace($content,strtolower(substr($content,0,$pos)) , 0,$pos);
	$content = substr_replace($content, '<span class="titlespan">', $pos, 1);
	$content = '.' . $content . '*</span>';
	return $content;

}
add_filter('the_title','get_karma_title');

//  Menu Builder
function karma_get_menu_from_pages() {

	$pages = & get_pages($args);
	if ( $pages ) {

		foreach ($pages as $page) {
			$output = '<li><a href="' . get_page_link($page->ID) . '">' . $page->post_title . '</a></li>';
			echo $output;
		}
	}

}

//Widgets Support
if ( function_exists('register_sidebar') )
	register_sidebar(
		array(
			'name' => 'Frontpage Sidebar',
			'before_widget' => '<div class="widget">', // Removes <li>
			'after_widget' => '</div>' // Removes </li>
		)
	);

if ( function_exists('register_sidebar') )
	register_sidebar(
		array(
			'name' => 'Bottom Bar Right Block',
			'before_widget' => '<div class="widget">', // Removes <li>
			'after_widget' => '</div>' // Removes </li>
		)
	);

if ( function_exists('register_sidebar') )
	register_sidebar(
		array(
			'name' => 'Bottom Bar Left Block',
			'before_widget' => '<div class="widget">', // Removes <li>
			'after_widget' => '</div>' // Removes </li>
		)
	);

function karma_styles(){
	if ( $_GET['page'] == basename(__FILE__) ) {
		if ( 'save' == $_REQUEST['action'] ) {
				if ( isset($_REQUEST['karma_blog_heading']) ) {
					update_option('karma_blog_heading',$_REQUEST['karma_blog_heading']);
				}
			wp_redirect("themes.php?page=functions.php&saved=true");
			die;
		}
	}
	add_theme_page('Customize Karma Fruit Theme', 'Karma Fruit Options', 'edit_themes', basename(__FILE__), 'karma_theme_settings');
}

add_action('admin_menu', 'karma_styles');

function karma_theme_settings() {
	if ( $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>Options saved.</strong></p></div>';
	?>
	<div class='wrap'>
		<h2>Karma Fruit Theme Options</h2>
		<div id="OptionsForm">
			<form method="post" action="">
				<p>
					<label for="karma_blog_heading">Blog Posts Heading:</label>
					<input type="text" name="karma_blog_heading" id="karma_blog_heading" value="<?php if (get_settings('karma_blog_heading')) echo get_settings('karma_blog_heading'); else echo 'News And Updates'; ?>" />
				</p>
				<p><input type="submit" name="submit" id="submit" value="Submit Options" />
				<input type="hidden" name="action" value="save" /></p>
			</form>
		</div>
	</div>
	<?php

}


?>