<?php get_header(); ?>

	<div class="leftcontainer">

		<?php if ( function_exists('dynamic_sidebar') && dynamic_sidebar('Frontpage Sidebar') ) : else : ?>

			<div class="widget">
				<h2>Monthly Archives</h2>

				<ul>
					<?php wp_get_archives('type=monthly'); ?>
				</ul>
			</div>
			<div class="widget">
				<h2>Categories</h2>
				<ul>
					<?php wp_list_cats('sort_column=name&hierarchical=0'); ?>
				</ul>
			</div>
		<?php endif; ?>

	</div>



	<div class="rightcontainer">

		<?php if (have_posts()) : ?>
			<div id="newsupdate">
				<h1><?php if (get_settings('karma_blog_heading')) echo get_settings('karma_blog_heading'); else echo 'News And Updates'; ?></h1>

				<?php while (have_posts()) : the_post(); ?>

					<div class="news" id="post-<?php the_ID(); ?>">
						<div class="title"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link"><?php the_title()?></a> <div class="date"> by <?php the_author(); ?></div></div>
						<div class="date"><?php the_time('F jS, Y') ?></div>
						<?php the_content('Read the rest of this entry &raquo;'); ?>
					</div>

					<!--p class="postmetadata">Posted in <?php the_category(', ') ?> | <?php edit_post_link('Edit', '', ' | '); ?>  <?php comments_popup_link('No Comments &#187;', '1 Comment &#187;', '% Comments &#187;'); ?></p-->

				<?php endwhile; ?>

				<div class="navigation">
					<div class="left"><?php next_posts_link('&laquo; Previous Entries') ?></div>
					<div class="right"><?php previous_posts_link('Next Entries &raquo;') ?></div>
				</div>
			</div>
		<?php else : ?>

			<h1 class="center">Not Found</h1>
			<p class="center">Sorry, but you are looking for something that isn't here.</p>
			<?php include (TEMPLATEPATH . "/searchform.php"); ?>

		<?php endif; ?>

	</div>
	<div class="clear"></div>
<?php get_footer(); ?>
