<?php
	/*
		Template Name: Links
       */
?> 
<?php get_header(); ?>
	<div class="ncol"><!-- Begin of the narrow column -->
		<div class="lnks"><!-- Opens the Links Div -->
		<!-- Links -->
			<?php
				$link_cats = $wpdb->get_results("SELECT cat_id, cat_name FROM $wpdb->linkcategories");
				foreach ($link_cats as $link_cat) {
			?>
				<h2><?php echo $link_cat->cat_name; ?></h2>
						<ul>
							<?php wp_get_links($link_cat->cat_id); ?>
						</ul>
			<?php } ?>
		<!-- End of Links -->
		</div><!-- Closes the Link Div -->
	</div><!-- This closes the narrow column div, leave it where it is! do NOT place it before the php endif -->
<div class="sidebar">
	<ul>
		<li><!-- Activity -->
			<h2><?php _e('Activity'); ?></h2>
			<!--This will show the last 10 posts, including the last one. To change the number of post shown
			edit the 'nuberposts=x' to whatever value you want, and to skip the last one (or last 2, 3, etc.) 
			increase the value of 'offset=x' (default is "0" so it will start by the last post)-->
				<ul><?php
						$posts = get_posts('numberposts=10&offset=0');
						foreach ($posts as $post) :
					?>
					<li>
					<a href="<?php the_permalink(); ?>" title="<?php the_title() ?>"><?php the_title() ?></a>
					</li>
					<?php
						endforeach;
					?>
				</ul>
		</li><!-- End of Activity -->
		<li>
			<h2><?php _e('Pages'); ?></h2>
				<ul>
				<?php wp_list_pages('title_li='); ?>
				</ul>
		</li> 
		<li><!-- Archives -->
			<h2><?php _e('Archives'); ?></h2>
				<ul>
					<?php wp_get_archives('type=monthly'); ?>
				</ul>
		</li><!-- End of Archives -->	
		<li><!-- Categories -->
			<h2><?php _e('Categories'); ?></h2>
				<ul>
					<?php wp_list_cats('optioncount=0'); ?>
				</ul>
		</li><!-- End of Categories -->		
		<li><!-- Feeds -->
			<h2><?php _e('Feeds'); ?></h2>
				<ul>
					<li><a href="<?php bloginfo('rdf_url'); ?>" title="RDF/RSS 1.0 Feed">RDF/RSS 1.0</a></li>
					<li><a href="<?php bloginfo('rss_url'); ?>" title="RSS 0.92 Feed">RSS 0.92</a></li>
					<li><a href="<?php bloginfo('rss2_url'); ?>" title="RSS 2.0 feed">RSS 2.0</a></li>
					<li><a href="<?php bloginfo('atom_url'); ?>" title="Atom feed">Atom</a></li>
					<li><a href="<?php bloginfo('comments_rss2_url'); ?>" title="Comments RSS 2.0 Feed">Comments [RSS 2.0]</a></li>
				</ul>
		</li><!-- End of Feeds-->
	</ul>
</div>
<?php get_footer(); ?>