<?php /*
    Template Name: Page
   */
?>

<?php include "header.php"; ?>

<div id="container">

	<div id="sp-content">
		<div class="post">
			<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
			<h1 class="archives"><?php the_title(); ?></h1>
			<div class="storycontent">
				<?php the_content(); ?>
			</div>
			
			<?php wp_link_pages(); ?> 
			
			<div class="meta">
				Posted by <b><?php the_author() ?></b>
				in <?php the_category(' and') ?>  
				<?php the_time('F j, Y',display); ?> 
				<?php edit_post_link(__('Edit This'),' | '); ?>
			</div>

		</div>   

		<?php comments_template(); // Get wp-comments.php template ?>

		<?php endwhile; else: ?>
		<?php _e('Sorry, no posts matched your criteria.'); ?>
		<?php endif; ?>

	</div>

<?php include('footer.php'); ?>
