<?php get_header(); ?>
		
	<div id="content_box">

		<?php get_sidebar(); ?>

		<div id="content" class="posts">
	
		<?php if (have_posts()) : ?>

			<?php $post = $posts[0]; // Hack. Set $post so that the_date() works. ?>
	
			<?php /* If this is a category archive */ if (is_category()) { ?>				
			<h3 class="archive_head">Entries Tagged as '<?php echo single_cat_title(); ?>'</h3>
			
			<?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
			<h3 class="archive_head">Entries from <?php the_time('F Y'); ?></h3>
			
			<?php /* If this is a search */ } elseif (is_search()) { ?>
			<h3 class="archive_head">Search Results</h3>

			<?php } ?>

			<?php while (have_posts()) : the_post(); ?>
			<h2><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php the_title(); ?></a></h2>
			
			<h4 class="meta">
				<img src="<?php echo get_template_directory_uri() ?>/images/icon_comment.gif" alt="Comments" /> &nbsp;
				<?php comments_popup_link('0', '1', '%'); ?> &nbsp; 
				
				<img src="<?php echo get_template_directory_uri() ?>/images/icon_datearr.gif" alt="Date Arrow" />&nbsp;
				<?php the_time('F j, Y') ?> at <?php the_time('g:ia') ?> &nbsp; 
				
				<img src="<?php echo get_template_directory_uri() ?>/images/icon_user.gif" alt="User" />&nbsp;
				by <?php the_author() ?>
			</h4>
			
			<div class="entry">
				<?php the_excerpt() ?>
			</div>	
			<p class="tagged"><img src="<?php echo get_template_directory_uri() ?>/images/icon_tag.gif" alt="Tagged" /> &nbsp; <?php the_category(' &middot; ') ?><span><img src="<?php echo get_template_directory_uri() ?>/images/icon_comment.gif" alt="Comments" /> &nbsp;<?php comments_popup_link('Add Your Comment', 'Add Your Comment', 'Add Your Comment'); ?></span></p>
			
			<?php endwhile; ?>
			
			<?php include (TEMPLATEPATH . '/navigation.php'); ?>

		<?php else : ?>
		
			<h2 class="page_header">Nothing Found!</h2>
			<p>Try giving it another shot.</p>
			<div class="entry">
				<?php include (TEMPLATEPATH . '/searchform.php'); ?>
			</div>
			
		<?php endif; ?>
			
		</div>
			
	</div>
		
<?php get_footer(); ?>