<?php get_header(); ?>

	<div id="content_box">

		<?php get_sidebar(); ?>
		
		<div id="content" class="posts single">

		<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
			<h2 id="post-<?php the_ID(); ?>"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php the_title(); ?></a></h2>
			
			<h4 class="meta">
				<img src="<?php echo get_template_directory_uri() ?>/images/icon_comment.gif" alt="Comments" /> &nbsp;
				<?php comments_number('0', '1', '%'); ?> &nbsp; 
				
				<img src="<?php echo get_template_directory_uri() ?>/images/icon_datearr.gif" alt="Date Arrow" />&nbsp;
				<?php the_time('F j, Y') ?> at <?php the_time('g:ia') ?> &nbsp; 
				
				<img src="<?php echo get_template_directory_uri() ?>/images/icon_user.gif" alt="User" />&nbsp;
				by <?php the_author() ?>
			</h4>
			
			<div class="entry">
				<?php the_content('<p>Read the rest of this entry &raquo;</p>'); ?>
				<?php link_pages('<p><strong>Pages:</strong> ', '</p>', 'number'); ?>
			</div>
			
			<p class="tagged"><img src="<?php echo get_template_directory_uri() ?>/images/icon_tag.gif" alt="Tagged" /> &nbsp; <?php the_category(' &middot; ') ?></p>
		
			<?php comments_template(); ?>
			
			<?php include (TEMPLATEPATH . '/navigation.php'); ?>
			
		<?php endwhile; else: ?>
		
		<h2>Not Found!</h2>
		<div class="entry">
			<p class="center">It seems as though you're lost. Try searching below to find what you're looking for.</p>
			<?php include (TEMPLATEPATH . "/searchform.php"); ?>
		</div>
			
		<?php endif; ?>
		
		</div>
			
	</div>

<?php get_footer(); ?>