<?php get_header(); ?>

<?php if (have_posts()) : ?>

	<?php $post = $posts[0]; // Hack. Setta la variabile $post in modo che la funzione the_date() venga eseguita correttamente. ?>

	<?php /* Se  l'archivio di una categoria */ if (is_category()) { ?>				
		<h2 class="pagetitle"><?php _e('Archives:'); ?> '<?php echo single_cat_title(); ?>'</h2>
	<?php /* Se  l'archivio di un determinato giorno */ } elseif (is_day()) { ?>
		<h2 class="pagetitle"><?php _e('Archives:'); ?> <?php the_time('j F Y'); ?></h2>
	<?php /* Se  un archivio mensile */ } elseif (is_month()) { ?>
		<h2 class="pagetitle"><?php _e('Archives:'); ?> <?php the_time('F Y'); ?></h2>
	<?php /* Se  un archivio annuale */ } elseif (is_year()) { ?>
		<h2 class="pagetitle"><?php _e('Archives:'); ?> <?php the_time('Y'); ?></h2>
	<?php /* Se  la pagina di ricerca */ } elseif (is_search()) { ?>
		<h2 class="pagetitle"><?php _e("Search"); ?></h2>
	<?php /* Se  una pagina di archivio suddivisa in pi pagine */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
		<h2 class="pagetitle"><?php _e('Archives:'); ?></h2>
	<?php } ?>

	<?php while (have_posts()) : the_post(); $loopcounter++; ?>

		<div class="post" id="post-<?php the_ID(); ?>">

			<h2><a href="<?php the_permalink() ?>" rel="bookmark" title="Permalink: <?php the_title(); ?>"><?php the_title(); ?></a></h2>
			<?php if ( ! is_page() ) { ?>
				<p class="details_small">
					<?php the_category(', ') ?> 
					<?php edit_post_link(__('Edit This'), '| ',''); ?>
					<?php if ( ! is_single() ) { ?> | 
					<?php comments_popup_link(__('Comments (0)'), __('Comments (1)'), __('Comments (%)')); ?>
					<?php } ?>
				</p>
			<?php } ?>

			<?php
				if ( is_home() || is_single() || is_page() AND $loopcounter <= 1 ) {
					the_content(__('(more...)'));
				}
				else {
					the_excerpt();
				} 
			?>

			<p class="date"><?php the_author(); ?> @ <?php the_time('F j, Y') ?></p>

		</div>
		
		<?php if ( is_single() ) comments_template(); ?>

	<?php endwhile; ?>
	<?php if ( ! is_single() && ! is_home() ) { ?>
		<div class="navigation">
			<?php posts_nav_link('', '<span class="alignleft">'. __('&laquo; Previous Page') .'</span>', '<span class="alignright">'. __('Next Page &raquo;').'</span>'); ?>
		</div>
	<?php } ?>

<?php else : ?>

	<h2 class="center">Not found</h2>
	<p class="center"><?php _e('Sorry, no posts matched your criteria.'); ?></p>
	
<?php endif; ?>

<?php get_footer(); ?>
