<?php get_header(); ?>

	<div id="content">

		<?php if (have_posts()) : ?>

		<?php $post = $posts[0]; ?>
		<?php /* If this is a category archive */ if (is_category()) { ?>
		<h1 class="pagetitle">Topic: <?php echo single_cat_title(); ?></h1>
		<?php /* If this is a daily archive */ } elseif (is_day()) { ?>
		<h1 class="pagetitle">Archive: <?php the_time('F jS, Y'); ?></h1>
		<?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
		<h1 class="pagetitle">Archive: <?php the_time('F, Y'); ?></h1>
		<?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
		<h1 class="pagetitle">Archive: <?php the_time('Y'); ?></h1>
		<?php /* If this is an author archive */ } elseif (is_author()) { ?>
		<h1 class="pagetitle">Author Archive</h1>
		<?php /* If this is a paged archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
		<h1 class="pagetitle">Blog Archives</h1>

		<?php } ?>

		<?php while (have_posts()) : the_post(); ?>

			<div class="post" id="post-<?php the_ID(); ?>">
				<h1><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php the_title(); ?></a></h1>

				<div class="post-date"><?php the_time('F jS, Y') ?></div>

				<div class="entry">
					<?php the_content('Continue &raquo;'); ?>
				</div>

				<div class="post-info">Topics: <?php the_category(', ') ?> | <?php edit_post_link('Edit', '', ' | '); ?>  <?php comments_popup_link('No Comments &#187;', '1 Comment &#187;', '% Comments &#187;'); ?></div>
			</div>

		<?php endwhile; ?>

		<div class="navigation">
			<div class="alignleft"><?php next_posts_link('&laquo; Previous') ?></div>
			<div class="alignright"><?php previous_posts_link('Next &raquo;') ?></div>
		</div>

		<?php else : ?>

			<h1>Not Found</h1>
			<p>Sorry, we could not find what you are looking for.</p>

		<?php endif; ?>

	</div>

<?php get_sidebar(); ?>

<?php get_footer(); ?>
