<?php get_header(); ?>

<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

<div class="post single" id="post-<?php the_ID(); ?>">
	<h2 class="title"><a href="<?php echo get_permalink() ?>" rel="bookmark" title="Permanent Link: <?php the_title(); ?>"><?php the_title(); ?></a></h2>
	<div class="postwrap">
	<div class="posttext">
<?php the_content('<p class="serif">' . __('Read the rest of this entry &raquo;') . '</p>'); ?>
<?php link_pages('<p><strong>' . __('Pages:') . '</strong> ', '</p>', 'number'); ?>
	</div>

	<div class="postdata">
	<ul>
		<li><?php 
			if (function_exists('get_author_posts_url'))
		$author_url = '<a href="' . get_author_posts_url($authordata->ID, $authordata->user_nicename).'">'.get_the_author() . '</a>';
	else
		$author_url = get_the_author();
		printf(__('This entry was posted on %s at %s
by %s.'), get_the_time(get_option('date_format')), get_the_time(), $author_url); ?><?php edit_post_link(__('Edit'), ' | '); ?></li>
		<li><?php _e('Categories:'); ?> <?php the_category(', '); ?>
<?php
	if (function_exists('STP_PostTags')) {
		echo ' | ', __('Tags:'), ' '; STP_PostTags(); } ?>
<?php
	if ('open' == $post->ping_status) : ?> | <a href="<?php trackback_url(true); ?>" rel="trackback"><?php _e('trackback'); ?></a><?php endif; ?></li>
	</ul>
	</div>
<?php comments_template(); ?>
	</div>
</div>
	
<?php endwhile; else: ?>
	<div class="post">
		<h2 class="title"><?php _e('Error 404 - Not Found'); ?></h2>
	<div class="postwrap">
	<div class="posttext">
			<p><?php _e('Sorry, there is no such page. Maybe you want to try the search.
If you came through a link from a different webpage you might want to inform
the webmaster of this page about the non-functional link.'); ?></p>
<div> <?php include (TEMPLATEPATH . '/searchform.php'); ?>
</div>
		</div>
	</div>
	</div>
<? endif; ?>
	

<?php get_footer(); ?>
