<div id="sidebar">

<a name="navigation"></a>
<ul id="sidebar1">

<li id="page-info">
<?php /* If this is the home page */ if (is_home() ) { ?>

<?php /* If this is an single entry page */ } else if (is_single()) { ?>

<?php /* If this is a page */ } elseif (is_page()) { ?>
<p>You are currently browsing a page in the <a href="<?php bloginfo('home'); ?>/"><?php echo bloginfo('name'); ?></a></p>

<?php /* If this is an attachment page */ } elseif (is_attachment()) { ?>
<p>You are currently browsing an attachment to a page.</p>

<?php /* If this is a 404 page */ } elseif (is_404()) { ?>
<p>Can't find the page you tried to browse.</p>

<?php /* If this is a category archive */ } elseif (is_category()) { ?>
<p>You are currently browsing the archives for the <?php single_cat_title(''); ?> category.</p>

<?php /* If this is a yearly archive */ } elseif (is_day()) { ?>
<p>You are currently browsing the <a href="<?php bloginfo('home'); ?>/"><?php echo bloginfo('name'); ?></a> archives
for the day <?php the_time('l, F jS, Y'); ?>.</p>

<?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
<p>You are currently browsing the <a href="<?php bloginfo('home'); ?>/"><?php echo bloginfo('name'); ?></a> archives
for <?php the_time('F, Y'); ?>.</p>

<?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
<p>You are currently browsing the <a href="<?php bloginfo('home'); ?>/"><?php echo bloginfo('name'); ?></a> archives
for the year <?php the_time('Y'); ?>.</p>

<?php /* If this is a monthly archive */ } elseif (is_search()) { ?>
<p>You have searched the <a href="<?php echo bloginfo('home'); ?>/"><?php echo bloginfo('name'); ?></a> archives
for <strong>'<?php the_search_query(); ?>'</strong>. If you are unable to find anything in these search results, you can try one of these links.</p>

<?php /* If this is a monthly archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
<p>You are currently browsing the <a href="<?php echo bloginfo('home'); ?>/"><?php echo bloginfo('name'); ?></a> archives.</p>

<?php } ?>
</li>

<?php if ( function_exists('dynamic_sidebar') && dynamic_sidebar(1) ) : else : ?>
<li id="pages">
<ul id="navigation">
<li><a href="<?php bloginfo('url'); ?>">Home</a></li>
<?php wp_list_pages('title_li='); ?> 
</ul>
</li>

<li id="author">
<h2>Author</h2>
<p>A little something about you, the author. Nothing lengthy, just an overview.</p>
</li>

<li id="archives">
<h2>Archives</h2>
<ul>
<?php wp_get_archives('type=monthly'); ?>
</ul>
</li>

<?php wp_list_categories('title_li=<h2>Categories</h2>'); ?>

<li id="calendar">
<h2>Calendar</h2>
<?php get_calendar(1); ?>
</li>

<li id="search">
<h2>Search</h2>
<?php include (TEMPLATEPATH . '/searchform.php'); ?>
</li>

<?php endif; /* end of dynamic sidebar */ ?>

</ul>

</div> <!-- div#sidebar -->

