<?php
if ( function_exists('register_sidebar') )
	register_sidebar(array(
		'before_widget' => '<div class="sidebox">', // Removes <li>
		'after_widget' => '</div>', // Removes </li>
		'before_title' => '<h1>', // Replaces <h2>
		'after_title' => '</h1>', // Replaces </h2>
	));
?>
<?php
$ns_options = array(
                    "reset" => "monthly", //reset hourly, daily, weekly, monthly, yearly, all
                    "limit"  => 10, //maximum number of commentator's to show
                    "filter_users" => "Administrator", //commma seperated list of users (nate,jeff,etc)
                    "filter_urls" => "", //commma seperated list of full or partial URL's (www.badsite.com,etc)
                    "none_text" => "None yet!", //if there are no commentators, what should we display?
                    "make_links" => 1, //link the commentator's name to thier website?
                    "name_limit" => 28, //maximum number of characters a commentator's name can be, before we cut it off with an ellipse
                    "start_html" => "<li>",
                    "end_html"   => "</li>",
                   );
$ns_options = ns_format_option($ns_options);
function commenter_check() {
	global $wpdb, $ns_options;
	   if($ns_options["reset"] != '') {
      $reset_sql = "DATE_FORMAT(comment_date, '$ns_options[reset]') = DATE_FORMAT(CURDATE(), '$ns_options[reset]')";
   } else {
      $reset_sql = "1=1";
   }
	$commenters = $wpdb->get_results("
	   SELECT COUNT(comment_author) AS comment_comments, comment_author
	   FROM $wpdb->comments
	   WHERE $reset_sql
	      AND comment_author NOT IN($ns_options[filter_users])
	      AND comment_author != ''
	      AND comment_type != 'pingback'
	      AND comment_approved = '1'
	   GROUP BY comment_author
	   ORDER BY comment_comments DESC LIMIT $ns_options[limit]
	");
	if($commenters != NULL)	return true; 
	else return false;
}
function ns_format_option($options) {
   //$reset needs to turn into %sql format
	if($options["reset"] == "hourly") {
      $options["reset"] = "%Y-%m-%d %H";
   } elseif($options["reset"] == "daily") {
      $options["reset"] = "%Y-%m-%d";
   } elseif($options["reset"] == "weekly") {
      $options["reset"] = "%Y-%w";
   } elseif($options["reset"] == "monthly") {
      $options["reset"] = "%Y-%m";
   } elseif($options["reset"] == "yearly") {
      $options["reset"] = "%Y";
   } elseif($options["reset"] == "all") {
      $options["reset"] = ""; //just use monthly
   } else {
      $options["reset"] = "%Y-%m"; //just use monthly
   }
   //$filter urls needs to be comma seperated with single quotes
   $filter_urls = trim($options["filter_urls"]);
   $filter_urls = explode(",", $filter_urls);
   for($i=0; $i<count($filter_urls); $i++) {
      $new_urls .= " AND comments_author_url NOT LIKE '%" . trim($filter_urls[$i]) . "%'";
   }
   //echo $new_urls;
   $options["filter_urls"] = $new_urls;
   //lets trim $limit just for the hell of it. (you never know)
   $options["limit"] = trim($options["limit"]);
   $options["name_limit"] = trim($options["name_limit"]);
   //$filter_users needs to be comma seperated with single quotes
   $filter_users = trim($options["filter_users"]);
   $filter_users = explode(",", $filter_users);
   for($i=0; $i<count($filter_users); $i++) {
      $new_users[] = "'" . trim($filter_users[$i]) . "'";
   }
   $options["filter_users"] = implode(",", $new_users);
   return $options;
}
?>