<?php get_header(); ?>

	<div id="content">
	
	<?php if( have_posts() ): ?>
	
	
		<?php $post = $posts[0]; ?>
		
		<?php if( is_category() ) { ?>
			<h2><?php _e( 'Archive for' ); ?> <?php echo single_cat_title(); ?></h2>
		
		<?php } elseif( is_day() ) { ?>
			<h2><?php _e( 'Archive for' ); ?> <?php the_time( 'F j, Y' ); ?></h2>
		
		<?php } elseif( is_month() ) { ?>
			<h2><?php _e( 'Archive for' ); ?> <?php the_time( 'F, Y' ); ?></h2>

		<?php } elseif( is_year() ) { ?>
			<h2><?php _e( 'Archive for' ); ?> <?php the_time( 'Y' ); ?></h2>

		<?php } elseif( is_author() ) { ?>
			<h2><?php _e( 'Author Archive' ); ?></h2>

		<?php } elseif( is_search() ) { ?>
			<h2><?php _e( 'Search Results' ); ?></h2>

		<?php } ?>
	
	
		<?php while( have_posts() ) : the_post(); ?>
		
		<div class="post" id="post-<?php the_ID(); ?>">
		
			<h2><a href="<?php the_permalink() ?>" title="Permalink"><?php the_title(); ?></a></h2>
			<div class="entry"><?php the_content( __( 'Read the rest of this entry &raquo;' ) ); ?></div>
				
			<small><?php _e( 'Posted by' ); ?> <?php the_author_posts_link(); ?> <?php _e( 'on' ); ?> <?php the_time( 'F jS, Y' ) ?> <?php edit_post_link( 'Edit',' &#183; ', '' ); ?></small>
			
			<div class="postmetadata">
			<?php _e( 'Filed under' ); ?> <?php the_category( ', ' ); ?> &#183; 
			<?php comments_popup_link( __( 'No comment &raquo;' ), __( 'Comments (1) &raquo;' ), __( 'Comments (%) &raquo;' ), 'commentslink', __( 'Comments off' ) ); ?>
			</div>
				
			<!--
			<?php trackback_rdf(); ?>
			-->

		</div>
		
		<?php endwhile; ?>


		<?php if( function_exists( 'wp_pagenavi' ) ) : ?>
		
			<div class="pagenav-alt"><?php wp_pagenavi(); ?></div>
			
		<?php else : ?>
		
			<div class="pagenav">
			<div class="alignleft"><?php posts_nav_link( '', __( '' ), __( '&laquo; Previous entries' ) ); ?></div>
			<div class="alignright"><?php posts_nav_link( '', __( 'Next entries &raquo;' ), __( '' ) ); ?></div>
			</div>
			
			<div class="clear"></div>
			
		<?php endif; ?>


	<?php else : ?>

		<h2><?php _e( "Not Found" ); ?></h2>

		<p><?php _e( "Sorry, but you are looking for something that isn't here." ); ?></p>

	<?php endif; ?>
		
	</div>
	
	<?php get_sidebar(); ?>	
	
	<div class="clear"></div>
	
<?php get_footer(); ?>