<?php
/*
Template Name: Archives
*/
?><?php get_header(); ?>


<div id="content">

<!-- google_ad_section_start -->

<h1 class="pagetitle">Folder contents</h1>

<div id="post">

<?php

/***************************************************************************
                      AutoIndex.php by Justin Hagstrom
                             -------------------

   version              : 1.2.5
   date                 : November 26, 2003

   copyright            : Copyright (C) 2002-2003 Justin Hagstrom
   license              : GNU General Public License (GPL)

   website              : http://autoindex.sourceforge.net
   forum                : http://autoindex.tacticalcenter.net
   email                : JustinHagstrom [at] yahoo [dot] com



   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

 ***************************************************************************/



/***************************************************************************
 *   Change the following variables
 *   Refer to readme.html for help
 ***************************************************************************/


ob_start();
bloginfo('template_directory');
$templatedir = trim(ob_get_contents());
ob_end_clean();

$base_dir = ".";
$imagepath = $templatedir . "/images/icons";


/*  Optional settings:  */

$allowUploads = 0;
$useLoginSystem = 1;
$userlist = 'userlist.txt';
$allowFileOverwrites = 0;

$DontLogTheseIPs = array('127.0.0.*');

$index = '';
$HiddenFiles = array($userlist, $imagepath, 'languages', '*.php');
$ShowDotFiles = 0;
$ShowBackupFiles = 0;

$EnableSearching = 1;
$simpleSearches = 0;

$showDirSize = 1;
$showTotalCount = 0;
$showFolderCount = 0;
$separateFilesAlphabetically = 0;
$separateFoldersAlphabetically = 0;

/***************************************************************************
 *   This section lets you change the language
 *   of anything displayed in the script
 ***************************************************************************/

/* Currently the choices are:

bg (for Bulgarian)
da (for Danish)
de (for German)
en (for English)
es (for Spanish)
fr (for French)
it (for Italian)
nl (for Dutch)
no (for Norwegian)
pl (for Polish)
pt_BR (for Brazilian Portuguese)
ru (for Russian)
sv (for Swedish)
zh (for Chinese)
*/

//Change the "en" to display the script in another language:
// require_once('languages/en.php');
$words = array();
$words["index of"] = "Index of";
$words['file'] = "file";
$words['size'] = "size";
$words['modified'] = "modified";
$words['parent directory'] = "parent directory";
$words['files']= "files";
$words['total size']= "total size";
$words['total files']= "total files";
$words['total folders']= "total folders";
$words['search results']= "search results";
$words['no results']= "no results";
$words['end of results']= "end of results";
$words['found']= "found";
$words['folders']= "folders";
$words['both']= "both";
$words['search']= "search";

/***************************************************************************
 *   YOU DO NOT NEED TO EDIT ANYTHING BELOW HERE
 *   but you can if you want to, if you know what you're doing ;-)
 ***************************************************************************/

$posix = (stristr(php_uname(), 'win')) ? 0 : 1; //check server OS

//make sure all the variables are set correctly:
if (!isset($base_dir, $index, $imagepath, $userlist, $simpleSearches,
	$HiddenFiles, $showDirSize, $showTotalCount, $EnableSearching, $ShowDotFiles, $ShowBackupFiles,
	$allowUploads, $separateFilesAlphabetically, $separateFoldersAlphabetically, $useLoginSystem,
	$allowFileOverwrites, $showFolderCount, $DontLogTheseIPs)
)
{
	die('<p>Error...</p><p>This script is not configured properly.</p><p>If you are the Webmaster, make sure you read the readme.html file, and set all the variables correctly.</p>');
}

if (!isset($words))
{
	die('<p>Error...</p><p>You need to include a language.php file that includes the variable $words.</p>');
}

if ($base_dir == '')
{
	die('<p>Error...</p><p>Make sure $base_dir has been assigned a value.</p>');
}

if (ereg('[^/\\]{1}$', $base_dir))
//make sure there is a slash at the end of base_dir
{
	$base_dir .= '/';
}

if (!is_dir($base_dir))
{
	die('<p>Error...</p><p>This script is not configured properly.</p><p><b>'.htmlentities($base_dir)
		.'</b> is not a valid directory.<br />Check the $base_dir variable.</p><p>If you are the Webmaster, make sure you read the readme.html file, and set all the variables correctly.</p>');
}
if ($base_dir[0] == '/')
{
	echo '<p>Error...</p><p>Cannot view that directory.</p>';
	$donotshow = 1;
}

function match($a, $b)
//determines if two strings match (includes wildcards, and is case-sensitive based on OS)
{
	global $posix, $simpleSearches;
	$replace = array(
		'.' => '\.',
		'^' => '\^',
		'$' => '\$',
		'[' => '\[',
		']' => '\]',
		'(' => '\(',
		')' => '\)',
		'{' => '\{',
		'}' => '\}',
		'|' => '\|',
		'\\' => '\\\\',
		'*' => '[^/]*',
		'+' => '[^/]+',
		'?' => '[^/]?');
	$b = strtr($b, $replace);
	if (!$simpleSearches)
	{
		$b = '^' . $b . '$';
		if ($posix)
		{
			return ereg($b, $a);
		}
	}
	return eregi($b, $a);
}

function match_in_array($string, $array)
{
	foreach($array as $thisitem)
	{
		if (strlen($thisitem) && match($string, $thisitem))
		{
			return 1;
		}
	}
	return 0;
}

function isHidden($fn)
{
	global $HiddenFiles, $ShowDotFiles, $ShowBackupFiles;
	if (!$ShowBackupFiles && $fn[strlen($fn) - 1] == '~')
	{
		return 1;
	}
	if (!$ShowDotFiles && $fn[0] == '.')
	{
		return 1;
	}
	if (!count($HiddenFiles))
	{
		return 0;
	}
	return match_in_array($fn, $HiddenFiles);
}

function evalDir($d)
//check $subdir for "bad" things, and deal with ".."
{
	$dirs = explode('/', stripslashes($d));
	for($i=0; $i<count($dirs); $i++)
	{
		if ($dirs[$i] == '.')
		{
			array_splice($dirs, $i, 1);
			$i = -1;
		}
		else if (ereg('^[\.]{2}', $dirs[$i])) //if it starts with two dots
		{
			array_splice($dirs, $i-1, 2);
			$i = -1;
		}
	}
	$newDir = (strlen($d) && $d[0] == '/') ? '/' : '';
	foreach($dirs as $t)
	{
	if (strlen($t) && !isHidden($t))
		{
			$newDir .= "$t/";
		}
	}
	if (substr($d, -1) != '/')
	{
		return substr($newDir, 0, -1);
	}
	return $newDir;
}

//get the filename of this file:
$thisFile = $_SERVER['PHP_SELF'];

//get all the user defined variables:
$_GET["dir"] = substr($_SERVER["REQUEST_URI"],1,-1) . "/";
$subdir = isset($_GET['dir']) ? evalDir(rawurldecode($_GET['dir'])) : '';

//size of the "chunks" that are read at a time from the file (when $forceDownload is on)

$dir = $base_dir.$subdir;

// print "<pre>";
// print_r($_SERVER);
// die($dir);

function get_filesize($size)
//give a size in bytes, and this will return the appropriate measurement format
{
	if ($size <= 0)
	{
		return '0 B';
	}
	$u = array('B', 'KB', 'MB', 'GB', 'TB');
	for($i=count($u)-1; $i>=0; $i--)
	{
		$s = number_format($size/pow(1024, $i), 1);
		if ($s >= 1)
		{
			return "$s $u[$i]";
		}
	}
	return '<1 B';
}

function getAllFiles($path)
//Returns every file and folder in $path
{
	$list = array();
	if (!($hndl = @opendir($path)))
	{
		return $list;
	}
	while(($file=readdir($hndl)) !== false)
	{
		if ($file != '.' && $file != '..')
		{
			$list[] = $file;
		}
	}
	closedir($hndl);
	return $list;
}

function GetFileList($path)
//Returns an array of filenames. Filters out "bad" files
{
	$f = $d = array();
	foreach(getAllFiles($path) as $file)
	{
		if (!isHidden($file))
		{
			if (is_file("$path/$file"))
			{
				$f[] = $file;
			}
			elseif (is_dir("$path/$file"))
			{
				$d[] = $file;
			}
		}
	}
	natcasesort($d);
	natcasesort($f);
	return array_merge($d, $f);
}

function dir_size($dir)
//Returns the total size of a directory (recursive) in bytes
{
	$totalsize = 0;
	foreach(GetFileList($dir) as $filename)
	{
		if (is_dir("$dir/$filename"))
		{
			$totalsize += dir_size("$dir/$filename");
		}
		else
		{
			$totalsize += filesize("$dir/$filename");
		}
	}
	return $totalsize;
}

function get_perms($file)
//returns the permissions of $file in standard unix format
{
	$p_bin = substr(decbin(fileperms($file)), -9);
	$p_arr = explode('.', substr(chunk_split($p_bin, 1, '.'), 0, 17));
	$perms = '';
	foreach($p_arr as $i => $thisitem)
	{ 
		$p_char = ($i%3==0 ? 'r' : ($i%3==1 ? 'w' : 'x'));
		$perms .= ($thisitem=='1' ? $p_char : '-' ).($i%3==2 ? ' ' : '');
  	}
	return substr($perms, 0, -1);
}

function num_files($dir)
//Returns the number of files in $dir (recursive)
{
	$count = 0;
	foreach(GetFileList($dir) as $thisitem)
	{
		if (is_file("$dir/$thisitem"))
		{
			$count++;
		}
		else if (is_dir("$dir/$thisitem/"))
		{
			$count += num_files("$dir/$thisitem/");
		}
	}
	return $count;
}

function icon($imagepath,$ext)
//find the appropriate icon depending on the extension (returns a link to the image file)
{
	if ($imagepath == '')
	{
		return '';
	}
	if ($ext == '')
	{
		$icon = 'generic';
	}
	else
	{
		$icon = 'unknown';

		$binary = array('exe', 'bin', 'msi', 'dll');
		$binhex = array('hqx');
		$tar = array('tar');
		$doc = array('doc', 'rtf', 'wri', 'pdf', 'xla', 'xls', 'xlt', 'xlw', 'ppt', 'pps', 'csv', 'dbf', 'dif');
		$ps = array('ps');
		$java = array('jar', 'java', 'jtk', 'class');
		$compressed = array('zip', 'z', 'tgz', 'gz', 'rar', 'bz2', '7z', 'ace',
			'sit', 'arc', 'taz', 'tbz2', 'deb', 'rpm');
		$image = array('jpg', 'png', 'bmp', 'gif', 'tif', 'tga', 'jpeg', 'tiff', 'psd', 'jpc',
			'jp2', 'jpx', 'swc', 'jfif', 'art', 'ico');
		$movie = array('mpg', 'avi', 'divx', 'mpeg', 'mov', 'ram', 'qt', 'wmv', 'mpe', 'asf');
		$sound = array('mp3', 'mp2', 'ogg', 'wav', 'mpc', 'flac', 'ape', 'aac', 'mp4', 'aif', 'aiff', 'au', 'la',
			'mid', 'midi', 'vqf', 'mod', 'wma', 'voc', 'mp+', 'mpp', 'bonk', 'ofr', 'shn', 'lqt', 'mpga',
			'ra', 'pac', 'wv', 'mka', 'mp1', 'spc', 'rmjb', 'rm');
		$uu = array('uue', 'uu', 'uud');
		$text = array('txt', 'md5', 'sfv', 'c', 'cpp', 'h', 'm3u', 'cc', 'cp');
		$comp = array('nfo', 'ini', 'cfg', 'log', 'conf');
		$web = array('html', 'htm', 'php', 'asp', 'phps', 'css', 'shtml', 'phtml', 'pl',
			'swf', 'cgi', 'php3', 'mht', 'mhtml', 'xml', 'jsp');
		$key = array('pgp', 'asc', 'ppk');

		$types = array($binary, $binhex, $tar, $doc, $compressed, $image, $uu, $text, $comp, $ps, $web, $key, $movie, $sound, $java);
		$names = array('binary', 'binhex', 'tar', 'doc', 'compressed', 'image', 'uu', 'text', 'comp1', 'ps', 'index', 'key', 'movie', 'sound', 'java');
		foreach($types as $k => $thisType)
		{
			if (in_array($ext, $thisType))
			{
				$icon = $names[$k];
				break;
			}
		}
	}
	return "<img alt=\"[$ext]\" height=\"16\" width=\"16\" src=\"$imagepath/$icon.png\" />";
}


if (!is_dir($dir))
//make sure the subfolder exists
{
	die("<p>Direct access to this page is not allowed</p>");
// 	die('<font class="cleartitlebar"><b>ERROR: The folder <i>'.htmlentities($dir).'</i> does not exist.</font></b>');
}

$file_array = GetFileList($dir);
$size_array = $date_a_array = $date_m_array = array();

echo '<h1 class="storytitle">'.$words['index of'] . " " . htmlentities($subdir).'</h1>';

?><?php ad_tip_block(); ?><?php
?><?php ad_after_title(); ?><?php

echo '<p><a href="../">Go to parent folder</a></p>';

//header of the table:
?><div ><!--style="overflow: auto"-->
<?php
echo '<table width="100%" id="dirlist">';

echo '<tr>';
echo '<th align="left">'.$words["file"].'</th>';

echo '<th align="right">'.$words['size'].'</th>';

echo '<th align="right">'.$words['modified'].'</th>';
echo '</tr>';

foreach($file_array as $thisitem)
{
	$pureitem = $thisitem;
	$thisitem = $dir.$thisitem;
	$date_m_array[] = filemtime($thisitem);
	$date_a_array[] = fileatime($thisitem);
	if (is_dir($thisitem))
	{
		if ($showDirSize)
		{
			$size_array[] = dir_size($thisitem);
		}
		else
		{
			$size_array[] = 0;
		}
	}
	else
	{
		$size_array[] = filesize($thisitem);
	}
}


echo '<tr class="paragraph"><td align="left">';

foreach($file_array as $key => $value)
//this is the list in the File column
{
	$npart = $dir.$value;
	$posix ? $user = posix_getpwuid(fileowner($npart)) : $user['name'] = 'N/A';
	$perms_stuff = htmlentities('Owner: '.$user['name']."   Permissions: ".get_perms($npart));
	$perms_stuff = "";

	if ($value != $file_array[0] && ($separateFilesAlphabetically && is_file($npart) || $separateFoldersAlphabetically && is_dir($npart)) && $value[0] != $file_array[$key-1][0])
	{
		echo '<p>';
	}
	echo '<a href="';
	if (is_dir($npart))
	{
		$moreinfo = "Folder";
		$perms_stuff = trim($moreinfo ."    " . $perms_stuff);
		echo rawurlencode($value) . '/" title="' . $perms_stuff  . '">';
		if ($imagepath != '')
		{
			echo '<img height="16" width="16" alt="[dir]" src="'.$imagepath.'/dir.png"/> ';
		}
		echo htmlentities($value);
		echo '</a>';
		echo "<br />\n";
	}
	else //is a file
	{
		$moreinfo = "File";
		if (ereg('\.src\.rpm$', $value)) $moreinfo = "Source RPM package";
		elseif (ereg('\.noarch\.rpm$', $value)) $moreinfo = "RPM package (installable on any architecture)";
		elseif (ereg('\.rpm$', $value)) $moreinfo = "Binary RPM package";
		elseif (ereg('\.tar.gz$', $value)) $moreinfo = "Compressed tar package";
		elseif (ereg('\.tgz$', $value)) $moreinfo = "Compressed tar package";
		elseif (ereg('\.tar.bz2$', $value)) $moreinfo = "Compressed tar package (with bzip2)";

		$perms_stuff = trim($moreinfo ."    " . $perms_stuff);

		echo rawurlencode($value) . '" title="' . $perms_stuff  . '">';
		echo icon($imagepath,strtolower(substr(strrchr(basename($npart), '.'), 1)));
		echo ' ';
		echo htmlentities($value);
		echo '</a>';
		echo "<br />\n";
	}
}

echo '</td><td align="right" style="white-space: nowrap;">';



foreach($file_array as $key => $value)
//this is the list in the Size column
{
	$npart = $dir.$value;
	if ($value != $file_array[0] && ($separateFilesAlphabetically && is_file($npart) || $separateFoldersAlphabetically && is_dir($npart)) && $value[0]!=$file_array[$key-1][0])
	{
		echo '<p>';
	}
	if ($imagepath != '')
	{
		echo '<img alt="" height="16" width="16" src="'.$imagepath.'/blank.gif" />';
	}
	if (is_dir($npart))
	{
		if ($showDirSize)
		{
			$ds = $size_array[$key];
			echo '<abbr title="'."Total Folder Size:\n".number_format($ds, 0, '.', ',').' bytes ('.get_filesize($ds).')">'.get_filesize($ds)."</abbr><br />\n";
		}
	    	else
		{
			echo "[dir]<br />\n";
		}
	}
	else if (is_file($npart))
	{
		echo '<abbr title="'."File Size:\n".number_format($size_array[$key], 0, '.', ',').' bytes ('.get_filesize($size_array[$key]).')">';
		echo get_filesize($size_array[$key])."</abbr><br />\n";
	}
	if ($value != $file_array[0] && ($separateFilesAlphabetically && is_file($npart) || $separateFoldersAlphabetically && is_dir($npart)) && $value[0]!=$file_array[$key-1][0])
	{
		echo '</p>';
	}
}

echo '</td><td align="right" style="white-space: nowrap;">';

foreach($file_array as $key => $value)
//this is the list in the Modified column
{
	$npart = $dir.$value;
	if ($value != $file_array[0] && ($separateFilesAlphabetically && is_file($npart) || $separateFoldersAlphabetically && is_dir($npart)) && $value[0]!=$file_array[$key-1][0])
	{
		echo '<p>';
	}
	$a = date('d-M-Y h:i:s A', $date_a_array[$key]);
	$m = date('d-M-Y h:i:s A', $date_m_array[$key]);
	if ($imagepath != '')
	{
		echo '<img alt="" height="16" width="16" src="'.$imagepath.'/blank.gif" />';
	}
	echo "<abbr title=\"Last Modified: $m\nLast Accessed: $a\">";
	echo date('m/d/y', $date_m_array[$key])."</abbr><br />\n";
}

echo '
</td>
</tr>
</table>';
?>
</div>

<?php

$folderCount = $fileCount = 0; $totalBytes = 0;
foreach($file_array as $key => $value) {
	$npart = $dir.$value;
	$totalBytes += $size_array[$key];
	if (is_dir($npart))
		{$folderCount++;}
	else //is a file
		{$fileCount++;}
}

echo '<p align="right"><b>'.$words['total size'].':</b>';
echo "\n<abbr title=\"".number_format($totalBytes, 0, '.', ',').' bytes ('.get_filesize($totalBytes).')">'.get_filesize($totalBytes)."</abbr>";
if ($showTotalCount)
{echo "<br/>".$words['total files'].": $fileCount<br />".$words['total folders'].": $folderCount";}
echo "</p>";


echo '
<!--

This site uses a modified version of AutoIndex PHP Script (version 1.2.5) by Justin Hagstrom.
Info at: http://autoindex.sourceforge.net

2003-Nov-26 5:59PM

-->
';

// if ($index == '')
// {
// 	echo '</body></html>';
// }

?>




</div>

<!-- google_ad_section_end -->

<?php ad_after_content(); ?>

</div>



<?php get_sidebar(); ?>

<?php get_footer(); ?>
