<?php
$fpath = ABSPATH."wp-content/fgallery/";
// Bug fix
require_once(ABSPATH . 'wp-includes/streams.php');
require_once(ABSPATH . 'wp-includes/gettext.php');

// Load language pack
$lang = get_option('fim_lang');
if($lang != '')
	load_textdomain('fgallery', ABSPATH . 'wp-content/plugins/fgallery/languages/'.$lang);
	
function fim_get_the_content()
{

	if(isset($_GET['image'])){
		$_GET['image'] = fim_get_image_id($_GET['image']);
		return fim_get_image();
	}
	if(isset($_GET['album'])){
		$_GET['album'] = fim_get_cat_id($_GET['album']);
		return fim_get_album();
	}
	else 
		return fim_get_overview();
}

function fim_get_overview()
{
	$galleries = fim_query_cats();

	$fim .= "<div class='fim'>";

	$fim .= fim_build_navigation();
	if($galleries)
	{
    	foreach($galleries as $gallery)
    	{
			$image = fim_get_cover($gallery->id);
    		//$image = fim_query_latest($gallery->id);
    		$count = fim_query_numrows($gallery->id);
    		$folder = get_bloginfo('wpurl')."/wp-content/fgallery/".fim_get_folder($gallery->id);
    		$title = ($image->title!="") ? "$title" : "Image";
    		$description = ($gallery->description == "")?"":__('Description', 'fgallery').": ".$gallery->description;
    		if($count != 0) 
    		{
    		$url = get_url("album/$gallery->id");
    
    			$fim .="
    			<div class='fim-album'>
    				<div class='fim-tn-border-t'>
    					<div class='fim-thumbnail'>								
    						<a href='$url'><img src='".$folder."thumb_".$image->image."' alt='$title'/></a>
    					</div>
    				</div>
    				<h4 class='fim-title'>
    					<a href='$url'>$gallery->catname</a>
    				</h4>	
    				<div class='fim-meta'>
    					".__('This album contains', 'fgallery')." $count ".__('pictures', 'fgallery').".
    				</div>	
    				<div class='fim-album-description'>
    					$description
    				</div>
    			</div>";
    			$fim .= "<div class='fim_clear'></div>";
    		}
    	}
 }
 else
    $fim .= "<p>".__('There are currently no albums to show', 'fgallery').".</p>";
	$fim .= "</div>";

	return $fim;
}
function fim_get_album()
{
	$images = fim_query_images($_GET['album']);
	$albumname = fim_get_cat_name_($_GET['album']);
	$fim .= "<div class='fim'>";
	$folder = get_bloginfo('wpurl')."/wp-content/fgallery/".fim_get_folder($_GET['album']);
	$lightbox = get_option('fim_use_lightbox');
	$fim .= fim_build_navigation(fim_get_cat_name_($_GET['album']));
	$fim .= "<div class='fim-album'>";

	foreach($images as $image)
	{
		$url = get_url("album/$_GET[album]/image/$image->id");
		$title = htmlentities ($image->title,ENT_QUOTES);
		$desc = htmlentities ($image->description,ENT_QUOTES);
		$fim .= "
				<div class='fim-tn-border-album'>
					<div class='fim-thumbnail'>";
					if($lightbox == 'false'){
						$fim .= "<a href='$url'><img src='".$folder."thumb_".$image->image."' alt='$title'/></a>";
					}else{
						$fim .= "<a href='".$folder.$image->image."' rel='lightbox[$albumname]' title='$title<br>$desc'><img src='".$folder."thumb_".$image->image."' \></a>";
					}
				$fim .=	"</div>
				</div>";
	}
	$fim .= "</div><div class='fim_clear'></div>";
	$fim .= "<p><a href='".get_url("")."'>".__('&laquo; Back to albums', 'fgallery')."</a></p>";
	$fim .= "</div>";
	return $fim;
}

function fim_get_image()
{
	$image = fim_query_one_image($_GET['image']);
	$title = ($image->title!="") ? "$title" : "Image";
	$back_link = get_url("album/$image->cat");
	$folder = get_bloginfo('wpurl')."/wp-content/fgallery/".fim_get_folder($image->cat);

	$fim .= "<div class='fim'>";
	$fim .= fim_build_navigation(fim_get_cat_name_($image->cat), $image->image, $image->cat);
	$fim .= "<div class='fim-photo-date'>$image->date</div>";
	
	$fim .= "<div class='fim-photo-block'>
				<div class='fim-photo'>
					<a href='$back_link'><img src='".$folder.$image->image."' alt='$title'/></a>
				</div> 
			</div>";
	$fim .= "<div class='fim_clear'></div>";
	$fim .= "<div class='fim-photo-nav'>
				<div class='fim-nav-buttons'>".fim_get_prev_image_link($image->id, $image->cat, $fimpage)."</div>
				<div class='fim-nav-buttons'><a href='$back_link'>Index</a></div>
				<div class='fim-nav-buttons'>".fim_get_next_image_link($image->id, $image->cat, $fimpage)."</div>
			</div>";
	$fim .= "<div class='fim_clear'></div>";
	$fim .= "<div class='fim-photo-desc'>
				<P>$image->description</p>
			</div></div>";
	$fim .= "<div class='fim_clear'></div>";
	return $fim;
	
	

}








// Get prev image link
function fim_get_next_image_link($curr_id, $curr_cat, $fimpage)
{
	global $wpdb, $table_prefix;
	$table_image = $table_prefix."fim_images";

	$sql = "SELECT id FROM $table_image WHERE id > '$curr_id' AND cat = '$curr_cat' ORDER BY id ASC LIMIT 0,1";
	$link = $wpdb->get_row($sql);
	if($link)
		//return "<a href='$fimpage?image=$link->id'>".__('Next &raquo;', 'fgallery')."</a>";
		return "<a href='".get_url("album/$curr_cat/image/$link->id")."'>".__('Next &raquo;', 'fgallery')."</a>";
	else
		return __('Next &raquo;' , 'fgallery');
	
}
// Get next image link
function fim_get_prev_image_link($curr_id, $curr_cat, $fimpage)
{
	global $wpdb, $table_prefix;
	$table_image = $table_prefix."fim_images";

	$sql = "SELECT id FROM $table_image WHERE id < '$curr_id' AND cat = '$curr_cat' ORDER BY id DESC LIMIT 0,1";
	$link = $wpdb->get_row($sql);
	if($link)
		//return "<a href='$fimpage?image=$link->id'>".__('&laquo; Prev', 'fgallery')."</a>";
		return "<a href='".get_url("album/$curr_cat/image/$link->id")."'>".__('&laquo; Prev', 'fgallery')."</a>";

	else
		return __('&laquo; Prev', 'fgallery');
}
// Get latest image
function fim_query_latest($catid)
{
	global $table_prefix, $wpdb;
	$table_image = $table_prefix . "fim_images";
	return $wpdb->get_row("SELECT image FROM $table_image WHERE cat = '$catid' ORDER BY date DESC LIMIT 0,1");
}
// Get album cover
function fim_get_cover($catid)
{
	global $table_prefix, $wpdb;
	$table_cat = $table_prefix . "fim_cat";
	$table_image = $table_prefix . "fim_images";

	$myid = $wpdb->get_row("SELECT cover FROM $table_cat WHERE id='$catid'");
	if(!$myid->cover)
		return fim_query_latest($catid);
	else
		return $wpdb->get_row("SELECT image,id FROM $table_image WHERE id='$myid->cover'");
}
// Get category name from id
function fim_get_cat_name_($id)
{
	global $table_prefix, $wpdb;
	$table_cat = $table_prefix . "fim_cat";
	$name = $wpdb->get_row("SELECT catname FROM $table_cat WHERE id = '$id'");
	return $name->catname;
}
// Get category path
function fim_get_cat_folder($id)
{
	global $table_prefix, $wpdb;
	$table_cat = $table_prefix . "fim_cat";
	$name = $wpdb->get_row("SELECT folder FROM $table_cat WHERE id = '$id'");
	return $name->folder;
}
// Get image name from id
function fim_get_image_name($id)
{
	global $table_prefix, $wpdb;
	$table = $table_prefix . "fim_images";
	$name = $wpdb->get_row("SELECT image FROM $table WHERE id = '$id'");
	return $name->image;
}
// Get image id from name
function fim_get_image_id($name)
{
	global $table_prefix, $wpdb;
	$table = $table_prefix . "fim_images";
	$name = $wpdb->get_row("SELECT id FROM $table WHERE image = '$name'");
	return $name->id;
}
// Get cat id from folder
function fim_get_cat_id($folder)
{
	global $table_prefix, $wpdb;
	$table = $table_prefix . "fim_cat";
	$name = $wpdb->get_row("SELECT id FROM $table WHERE folder = '$folder'");
	return $name->id;
}
// Get one image
function fim_query_one_image($imgid = "", $catd = "")
{
	global $wpdb, $table_prefix;
	$table_image = $table_prefix."fim_images";
	return $wpdb->get_row("SELECT * FROM $table_image WHERE id = '$imgid'");
}
// get all folders
function fim_get_all_folders()
{
	global $wpdb, $table_prefix;
	$table = $table_prefix."fim_cat";
	return $wpdb->get_results("SELECT folder FROM $table");
}
// Get folder
function fim_get_folder($id)
{	
	global $wpdb, $table_prefix;
	$table = $table_prefix."fim_cat";
	$name= $wpdb->get_row("SELECT folder FROM $table WHERE id = '$id'");
	return $name->folder."/";
}
// Get all images within a certain gallery
function fim_query_images($catid)
{
	global $wpdb, $table_prefix;
	$table_image = $table_prefix."fim_images";
	return $wpdb->get_results("SELECT * FROM $table_image WHERE cat = '$catid' AND status <> 'exclude' ORDER BY date");
}
// Get all galleries
function fim_query_cats()
{	
	global $wpdb, $table_prefix;
	$table_cat = $table_prefix."fim_cat";
	return $wpdb->get_results("SELECT * FROM $table_cat ORDER BY date DESC");
}
// Get gallery
function fim_get_gallery($id)
{	
	global $wpdb, $table_prefix;
	$table_cat = $table_prefix."fim_cat";
	return $wpdb->get_row("SELECT * FROM $table_cat WHERE id='$id'");
}

// Get number of rows
function fim_query_numrows($catid)
{
	global $wpdb, $table_prefix;
	$table_image = $table_prefix."fim_images";
	$count =  $wpdb->get_row("SELECT COUNT(*) as c FROM $table_image WHERE cat = '$catid'");
	return $count->c;
}

function fim_build_navigation($album = "", $image = "", $cat = "")
{
	$baseurl = get_url("");
	$albumurl = get_url("album/$cat");
	$t = fim_query_one_image(fim_get_image_id($image));
	$imagetitle = ($t->title == "")?$image:$t->title;
	$string = "<h4 class='fim-nav'><a href='$baseurl'>".__('Current Albums', 'fgallery')."</a>";
	if($album && $image)
		$string .= " &raquo; <a href ='$albumurl'>$album</a>";
	else
		$string .= " &raquo; $album";
	if($image)
		$string .= " &raquo; $imagetitle</a>";
	
	$string .= "</h4>";
	return $string;
	
}
// Random images from database
function fim_get_random($num, $size)
{
	global $wpdb, $table_prefix, $thumbs_folder, $fimpage;
	$table_image = $table_prefix."fim_images";

	$sql = "SELECT image, id, cat FROM $table_image ORDER BY RAND() LIMIT $num";
	$images = $wpdb->get_results($sql);
	if($images){
		foreach($images as $image)
		{
			$folder = get_bloginfo('wpurl')."/wp-content/fgallery/".fim_get_folder($image->cat);
	
			echo "<div class='fim_random'>
				<div class='fim-tn-border-sidebar'>
					<div class='fim-thumbnail'>
					<a href='".get_url("album/$image->cat/image/$image->id")."'><img src='".$folder."thumb_$image->image' alt=''  width='$size'/></a>
					</div>
				</div>
			</div>";
		}
	}
	echo "<div class='fim_clear'></div>";
}
// Get latest images regarless of album
function fim_get_latest($num, $size)
{
	global $wpdb, $table_prefix, $thumbs_folder, $fimpage;
	$table_image = $table_prefix."fim_images";

	$sql = "SELECT image, cat, id FROM  $table_image ORDER BY date desc LIMIT $num";
	$images = $wpdb->get_results($sql);
	if($images){
		foreach($images as $image)
		{
			$folder = get_bloginfo('wpurl')."/wp-content/fgallery/".fim_get_folder($image->cat);
	
			echo "<div class='fim_random'>
				<div class='fim-tn-border-sidebar'>
					<div class='fim-thumbnail'>
					<a href='".get_url("album/$image->cat/image/$image->id")."'><img src='".$folder."thumb_$image->image' alt=''  width='$size'/></a>
					</div>
				</div>
			</div>";
		}
	}
	echo "<div class='fim_clear'></div>";

}
// Builds the urls used in fGallery
function get_url($parms)
{        
  $urltype = get_option('fim_use_fancy_url');
	if ($parms != '')
	{
		$element = explode('/', $parms);
		for ($x = 1; $x < count($element); $x ++) {
			$element[$x] = urlencode($element[$x]);
		}
		$element[1] = fim_get_cat_folder($element[1]);
		$element[3] = fim_get_image_name($element[3]);

		if ($urltype == 'false')
		{
			$parms = '?'.$element[0].'='.$element[1].'&'.$element[2].'='.$element[3];
			$parms = str_replace('&=', '', $parms);
			return htmlspecialchars(get_bloginfo('url')."/wp-content/plugins/fgallery/fim_photos.php".$parms);
		}
		else
		{
			$parms = implode('/', $element);	
			return htmlspecialchars(get_bloginfo('url')."/".get_option('fim_baseurl')."/$parms");
		}
	}
	else
    {
        if ($urltype == 'false')
           return htmlspecialchars(get_bloginfo('url')."/wp-content/plugins/fgallery/fim_photos.php");
        else
            return htmlspecialchars(get_bloginfo('url')."/photos");
    }
}


