<?php
/*
Plugin Name: WP-ContactForm
Plugin URI: http://ryanduff.net/projects/wp-contactform/
Description: WP Contact Form is a drop in form for users to contact you. It can be implemented on a page or a post. It currently works with WordPress 1.5+
Author: Ryan Duff, Firas Durri
Author URI: http://ryanduff.net
Version: 1.1
*/ 

load_plugin_textdomain('wpcf'); // NLS

/* Declare strings that change depending on input. This also resets them so errors clear on resubmission. */
$wpcf_strings = array(
	'name' => '<div class="contactright"><input type="text" name="your_name" id="name" size="30" maxlength="50" value="' . $_POST['your_name'] . '" /> (required)</div>',
	'email' => '<div class="contactright"><input type="text" name="email" id="email" size="30" maxlength="50" value="' . $_POST['email'] . '" /> (required)</div>',
	'msg' => '<div class="contactright"><textarea name="msg" id="message" cols="35" rows="8" >' . $_POST['msg'] . '</textarea></div>',
	'error' => '');

/*This function adds javascript functionality to insert <!--contact form--> tag into post*/
function wpcf_add_head() {
	echo <<<END
		<script language="JavaScript" type="text/javascript">
		<!--		
			function insertAtCursor(myField, myValue) {
			  //IE support
			  if (document.selection) {
				myField.focus();
				sel = document.selection.createRange();
				sel.text = myValue;
			  }
			  //MOZILLA/NETSCAPE support
			  else if (myField.selectionStart || myField.selectionStart == '0') {
				var startPos = myField.selectionStart;
				var endPos = myField.selectionEnd;
				myField.value = myField.value.substring(0, startPos)
							  + myValue 
							  + myField.value.substring(endPos, myField.value.length);
			  } else {
				myField.value += myValue;
			  }
			}
		//-->
		</script>
END;
}

/*This function adds the "Contact Form" button to the quicktags menu. Taken from Alex King's JS Quicktags.*/
function wpcf_add_button()
{
	if( (!strstr($_SERVER['PHP_SELF'], 'post.php') && !strstr($_SERVER['PHP_SELF'], 'page-new.php')) || $_GET["action"] == 'editcomment' )
		return 0;

	echo <<<END
		<script language="JavaScript" type="text/javascript">
		<!--
			document.getElementById("quicktags").innerHTML += "<input type=\"button\" class=\"ed_button\" id=\"ed_list\" value=\"Contact Form\" onclick=\"insertAtCursor(document.post.content, '<!--contact form-->');\" />";
		//-->
		</script>
END;
}

/* This function checks for errors on input and changes $wpcf_strings if there are any errors. Shortcircuits if there has not been a submission */
function wpcf_check_input()
{
	if(!(isset($_POST['stage']))) {return false;} // Shortcircuit.
	
	global $wpcf_strings;
	$ok = true;
	$_POST['your_name'] = trim($_POST['your_name']);
	$_POST['msg'] = trim($_POST['msg']);

	if(empty($_POST['your_name']))
	{
		$ok = false;
		$wpcf_strings['name'] = '<div class="contactright"><input type="text" name="your_name" id="name" size="30" maxlength="50" value="' . $_POST['your_name'] . '" class="contacterror" /> (required)</div>';
	}
            
    if(!is_email($_POST['email']))
    {	
	    $ok = false;
	    $wpcf_strings['email'] = '<div class="contactright"><input type="text" name="email" id="email" size="30" maxlength="50" value="' . $_POST['email'] . '" class="contacterror" /> (required)</div>';
	}
    
    if(empty($_POST['msg']))
    {	
	    $ok = false;
	    $wpcf_strings['msg'] = '<div class="contactright"><textarea name="msg" id="message" cols="35" rows="8" class="contacterror">' . $_POST['msg'] . '</textarea></div>';
	}
	
	if($ok == true)
	{
		return true;
	}
	else {
		$wpcf_strings['error'] = '<div style="font-weight: bold;">' . stripslashes(get_option('wpcf_error_msg')) . '</div>';
		return false;
	}
}

/*Wrapper function which calls the form.*/
function wpcf_callback( $content )
{    
	global $wpcf_strings;
	
	/* Run the input check. */
    if(wpcf_check_input()) // If the input check returns true (ie. there has been a submission & input is ok)
    {
            $recipient = get_option('wpcf_email');
            $subject = get_option('wpcf_subject');
			$encoding = get_option('blog_charset');
            $success_msg = get_option('wpcf_success_msg');
			$success_msg = stripslashes($success_msg);
        
            $name = $_POST['your_name'];
            $email = $_POST['email'];
            $website = $_POST['website'];
            $msg = $_POST['msg'];
        
            $headers = "From: $name <$email>\n";  // your email client will show the person's email address like normal
            $headers .= "Content-Type: text/plain; $encoding\n"; // sets the mime type
        
            $fullmsg = "$name wrote:\n";
            $fullmsg .= $msg . "\n\n";
            $fullmsg .= "Website: " . $website . "\n";
            $fullmsg .= "IP: " . getip();
        
            mail($recipient, $subject, stripslashes($fullmsg), $headers);
        
            $results = '<div style="font-weight: bold;">' . $success_msg . '</div>';
            echo $results;
    }
    else // Else show the form. If there are errors the strings will have updated during running the inputcheck.
    {
        $form = '<div class="contactform">
        ' . $wpcf_strings['error'] . '
        	<form action="' . get_permalink() . '" method="post" name="form">
        		<div class="contactleft"><label for="name">' . __('Your Name: ', 'wpcf') . '</label></div>' . $wpcf_strings['name']  . '
        		<div class="contactleft"><label for="email">' . __('Your Email:', 'wpcf') . '</label></div>' . $wpcf_strings['email'] . '
        		<div class="contactleft"><label for="website">' . __('Your Website:', 'wpcf') . '</label></div><div class="contactright"><input type="text" name="website" id="website" size="30" maxlength="100" value="' . $_POST['website'] . '" /></div>
            	<div class="contactleft"><label for="message">' . __('Your Message: ', 'wpcf') . '</label></div>' . $wpcf_strings['msg'] . '
            	<div class="contactright"><input type="submit" name="Submit" value="Submit" /><input type="hidden" name="stage" value="process" /></div>
        	</form>
        </div>
        <div style="clear:both; height:1px;">&nbsp;</div>';
        return preg_replace('|<!--contact form-->|', $form, $content);
    }
}


/*Can't use WP's function here, so lets use our own*/
function getip()
{
	if (isset($_SERVER)) 
	{
 		if (isset($_SERVER["HTTP_X_FORWARDED_FOR"])) 
 		{
  			$ip_addr = $_SERVER["HTTP_X_FORWARDED_FOR"];
 		} 
 		elseif (isset($_SERVER["HTTP_CLIENT_IP"])) 
 		{
  			$ip_addr = $_SERVER["HTTP_CLIENT_IP"];
 		} 
 		else 
 		{ 		
 			$ip_addr = $_SERVER["REMOTE_ADDR"];
 		}
	} 
	else 
	{
 		if ( getenv( 'HTTP_X_FORWARDED_FOR' ) ) 
 		{
  			$ip_addr = getenv( 'HTTP_X_FORWARDED_FOR' );
 		} 
 		elseif ( getenv( 'HTTP_CLIENT_IP' ) ) 
 		{
  			$ip_addr = getenv( 'HTTP_CLIENT_IP' );
 		} 
 		else 
 		{
  			$ip_addr = getenv( 'REMOTE_ADDR' );
 		}
	}
return $ip_addr;
}


/*CSS Styling*/
function wpcf_css()
	{
	?>
<style type="text/css" media="screen">

		/* Begin Contact Form CSS */

		.contactform {
			width: 100%; 
			position: relative;
			}
		
		.contactleft {
			width: 25%; 
			text-align: right;
			clear: both; 
			float: left; 
			display: inline; 
			padding: 4px; 
			margin: 5px 0; 
			}
		
		.contactright {
			width: 70%;  
			float: right; 
			display: inline; 
			padding: 4px; 
			margin: 5px 0; 
			}

        .contacterror {
            border: 1px solid #ff0000;
        	}
		/* End Contact Form CSS */

	</style>

<?php

	}

// TODO: Update this to new options page technique after WP 1.5.1 is released
function wpcf_add_options_page()
	{
		add_options_page('Contact Form Options', 'Contact Form', 9, 'options-contactform.php');
	}

/* Action calls for all functions */

if(get_option('wpcf_show_quicktag') == true) {add_action('admin_footer', 'wpcf_add_button');}

add_action('admin_head', 'wpcf_add_options_page');
add_action('admin_head', 'wpcf_add_head');
add_filter('wp_head', 'wpcf_css');
add_filter('the_content', 'wpcf_callback', 7);

?>