<?php get_header(); ?>
	<?php if (have_posts()) : ?>
		<?php while (have_posts()) : the_post(); ?>
			<div class="post" id="post-<?php the_ID(); ?>">
				<h2><a href="<?php the_permalink() ?>" rel="bookmark" title="Permalink: <?php the_title(); ?>"><?php the_title(); ?></a></h2>
				<p class="details"><span class="icon-feed"><?php comments_rss_link('RSS 2.0'); ?></span> | <?php _e("Filed under:"); ?> <?php the_category(', ') ?></p>
				<p class="date"><?php the_author(); ?> @ <?php the_time('F j, Y') ?></p>
				<?php the_content(__('(more...)')); ?>
				<p class="details_small"><?php edit_post_link(__('Edit This'), '',' | '); ?><?php previous_post_link('&laquo; %link') ?> | <?php next_post_link('%link &raquo;') ?></p>
			</div>
			<?php comments_template(); ?>
		<?php endwhile; ?>
	<?php else : ?>
		<div class="post">
			<h2 class="center">Not found</h2>
			<p class="center"><?php _e('Sorry, no posts matched your criteria.'); ?></p>
		</div>
	<?php endif; ?>
<?php get_footer(); ?>
