<?php get_header(); ?>
	<?php if (have_posts()) : ?>
		<?php while (have_posts()) : the_post(); ?>
			<div class="post" id="post-<?php the_ID(); ?>">
				<h2><a href="<?php the_permalink() ?>" rel="bookmark" title="Permalink: <?php the_title(); ?>"><?php the_title(); ?></a></h2>
				<?php the_excerpt(); ?>
				<p class="details_small"><?php the_author(); ?> @ <?php the_time('F j, Y') ?> | <?php comments_popup_link(__('Comments (0)'), __('Comments (1)'), __('Comments (%)')); ?></p>
			</div>
		<?php endwhile; ?>
		<div class="navigation">
			<?php posts_nav_link(' &#8212; ', '<span class="alignleft">'. __('&laquo; Previous Page') .'</span>', '<span class="alignright">'. __('Next Page &raquo;').'</span>'); ?>
		</div>
	<?php else : ?>
		<div class="post">
			<h2 class="center">Not found</h2>
			<p class="center"><?php _e('Sorry, no posts matched your criteria.'); ?></p>
		</div>
	<?php endif; ?>
<?php get_footer(); ?>
