<?php get_header(); ?>

<div id="content">

  <?php if (have_posts()) : ?>
  	<?php $post = $posts[0]; // Hack. Set $post so that the_date() works. ?>
	<?php 
	if (is_category()) { ?>				
		<h3>Archive for the '<?php echo single_cat_title(); ?>' Category</h3>
	<?php }
	 
	elseif (is_day()) { ?>
		<h3>Archive for <?php the_time('F jS, Y'); ?></h3>
	<?php }
	
	elseif (is_month()) { ?>
		<h3>Archive for <?php the_time('F, Y'); ?></h3>
	<?php } 
	
	elseif (is_year()) { ?>
		<h3>Archive for <?php the_time('Y'); ?></h3>
	<?php } 
	
	elseif (is_author()) { ?>
		<h3>Author Archive</h3>
	<?php }
	 
	elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
		<h3>Blog Archives</h3>
	<?php } ?>

<?php while (have_posts()) : the_post(); ?>

    <div class="post" id="post-<?php the_ID(); ?>">

	  <div class="post-date"><span class="post-month"><?php the_time('M') ?></span> <span class="post-day"><?php the_time('d') ?></span></div>

	  <div class="entry">
        <h2><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php the_title(); ?></a> <?php edit_post_link('<img alt="Edit" title="Edit This Entry" src="' . get_bloginfo('template_directory') . '/images/edit.png" />', '', ''); ?></h2>
		<span class="post-cat"><?php the_category(', ') ?></span> <span class="post-author"><?php the_author_posts_link() ?></span> <span class="post-comments"><?php comments_popup_link('No Comments &#187;', '1 Comment &#187;', '% Comments &#187;'); ?></span>
	  </div><!-- [entry] -->

	  <div class="post-content">
			<?php the_content('Read the rest of this entry &raquo;'); ?>
	  </div>

	</div><!-- [post] -->

<?php endwhile; ?>

  <div class="navigation">
    <span class="previous-entries"><?php next_posts_link('Previous Entries') ?></span> <span class="next-entries"><?php previous_posts_link('Next Entries') ?></span>
  </div>

<?php else: ?>
  <p><?php _e('Sorry, no posts matched your criteria.'); ?></p>
  <?php include (TEMPLATEPATH . "/searchform.php"); ?>
<?php endif; ?>


</div><!--/content -->

<?php get_sidebar(); ?>

<?php get_footer(); ?>