<?php
/*
Template Name: Archives Page
*/
?>

<?php get_header(); ?>

<div id="content">
  
  <?php if (have_posts()) : the_post(); ?>
	
    <div class="post" id="post-<?php the_ID(); ?>">

        <h2><?php the_title(); ?> <?php edit_post_link('<img alt="Edit" title="Edit This Page" src="' . get_bloginfo('template_directory') . '/images/edit.png" />', '', ''); ?></h2>

        <div class="post-content">

			<?php the_content('Read the rest of this page &raquo;'); ?>
            <?php link_pages('<p><strong>Pages:</strong> ', '</p>', 'number'); ?>

          <h3>By month:</h3>
	        <ul>
	          <?php wp_get_archives('type=monthly&show_post_count=1'); ?>
            </ul>
			
          <h3>By category:</h3>
	        <ul>
	          <?php wp_list_cats('sort_column=name&optioncount=1&feed=rss'); ?>
	        </ul>

        </div><!-- [post-content] -->

    </div><!-- [post] -->
	
  <?php else: ?>
    <p><?php _e('No Entries found.'); ?></p>
  <?php endif; ?>

</div><!-- [content] -->

<?php get_sidebar(); ?>
<?php get_footer(); ?>
