<?php get_header(); ?>
<!-- START CONTENT -->
<div id="container">
  <!-- START POSTS LIST -->
  <?php if (have_posts()) : ?>
  
  <!-- START LOOP -->
  <?php while (have_posts()) : the_post(); ?>
  
  <!-- START POST -->
  <div class="post" id="post-<?php the_ID(); ?>">
  
    <!-- START DATE -->
    <acronym class="published" title="<?php the_time('F jS, Y'); ?>"> <span class="pub-month">
    <?php the_time('M'); ?>
    </span> <span class="pub-date">
    <?php the_time('j'); ?>
    </span> </acronym>
    <!-- END DATE-->
	
    <!-- START TITLE -->
    <h2><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>">
      <?php the_title(); ?>
      </a>
      <?php edit_post_link('Edit', '<sup>', '</sup>'); ?>
    </h2>
    <!-- END TITLE -->
	
    <!-- START DETAILS -->
    <small> Published in 
    <?php the_category(', ') ?>
   by
    <?php the_author() ?>
    | 
    <?php comments_popup_link('0 comments', 'one comment', '% comments &#187;'); ?>
    </small>
    <!-- END DETAILS -->
	
    <!-- START POST CONTENT -->
    <div class="entry">
      <?php the_content('Continue reading...'); ?>
    </div>
    <!-- END POST CONTENT -->
	
  </div>
  <!-- END POST -->
  
  <?php endwhile; ?>
  <!-- END LOOP -->
  
  <!-- START NAVIGATION -->
  <div class="navigation">
    <div class="alignleft">
      <?php next_posts_link('&laquo; Previous entries') ?>
    </div>
    <div class="alignright">
      <?php previous_posts_link('Next entries &raquo;') ?>
    </div>
  </div>
  <!-- END NAVIGATION -->
  
  <!-- IF NON EXISTENT -->
  <?php else : ?>
  <h2 class="center">Ooooops!!!</h2>
  <p class="center">I am sorry I didnt find what youre searching for.</p>
 
  <?php endif; ?>
  <!-- END POSTS LIST -->
</div>
<!-- END CONTENT -->
<?php get_sidebar(); // calls the sidebar ?>
<?php get_footer(); // calls the footer ?>
