<?php

/* functions to make this all easier */

$post_odd = true;

// open an entry (post) with the optional id $id and header text $head
function sp_entry_open( $id='', $head='' )
{
    global $post_odd;
    if ( $post_odd ) :
        $class = "";
    else:
        $class = "-alt";
    endif;
    $post_odd = !$post_odd;

    if ($id)
        $id = " id=\"$id\"";
    echo "<div class=\"entry$class\"><div class=\"entrytitle\"$id>$head</div><div class=\"entrytext\">";
}

// close an entry, complete with footer text if specified
function sp_entry_close( $foot='' )
{
    echo "</div><div class=\"entryfoot\">$foot</div></div>";
}

// used to render a post without calling sp_post_head_default and such
function sp_post( )
{
    sp_post_head_default( );
    the_content( '[more]', 0, '' );
    sp_post_foot_default( );
}

// the header used in posts, handy if you want to automate it and then
// have some additional content in a page template or something
function sp_post_head_default( )
{
    global $post_odd, $user_ID;
    if ( $post_odd ) :
        $class = "";
    else:
        $class = "-alt";
    endif;
    $post_odd = !$post_odd;

    $tdir = get_bloginfo('template_directory');
    ?>
    <div class="entry<?php echo $class; ?>">
        <div class="entrytitle">
            <h2><a class="permalink" href="<?php the_permalink(); ?>" >
                <?php the_title(); ?>
            </a></h2>
            <?php if ( !is_page() && !is_attachment( ) ) { ?>
                <span class="datecatlinks dinline pin">
                Posted <?php the_time('F jS, Y'); ?> in <?php sp_category_friendly( ); ?><br/>
                </span>

                <?php // if you have UltimateTagWarrior installed, posts will show their tags as well
                if ( function_exists( 'sp_get_tags' ) )
                {
                ?>
                    <span class="taglinks dinline pin">
                    <?php sp_get_tags(); ?>
                    </span>
                <?php } ?>
            <?php } // endif is_page ?>
        </div>
        <div class="entrytext">
    <?php
}

// the footer used in normal posts -- surprisingly handy as a function.
function sp_post_foot_default( )
{
    global $user_ID, $post;
    $tdir = get_bloginfo('template_directory');
    ?>
    </div>
    <div class="entryfoot">
        <?php // comments link
        if ( !is_single( ) && !is_page( ) )
        {
            comments_popup_link(
                "no comments",
                "1 comment",
                "% comments",
                'commentlink dinline pin',
                'Comments Disabled'
            );
        }
        if ( $user_ID && user_can_edit_post( $user_ID, $post->post_ID ) && !is_attachment( ) )
        {
            if ( !is_single( ) && !is_page( ) )
                echo " &bull; ";
            $editlink = get_bloginfo('siteurl')."/wp-admin/post.php?action=edit&amp;post=$post->ID";
            echo "<a href=\"$editlink\" class=\"editlink dinline pin\">edit</a>";
        }
        if ( (!is_single( ) && !is_page( ) && !is_attachment( )) || user_can_edit_post( $user_ID, $post->post_ID ))
            $bull = ' &bull;';
        else
            $bull = '';
        link_pages( $bull.' <span class="pagelink dinline pin">pages: ', '</span>', 'number', '', '', '%' );
        ?>
    </div>
    </div>
    <?php
}

function sp_edit_post_link_filter( $link='' )
{
    echo "EDITPOSTLINKFILTER<br/>$link";
    return $link;
}
add_filter( 'edit_post_link', 'sp_edit_post_link_filter' );

// used to render categories in a friendlier manner
// formatted like Cat1, Cat2, and Cat3 instead of
// the more 'robotic' Cat1, Cat2, Cat3
function sp_category_friendly( )
{
    $cats = get_the_category( );
    $c = count($cats);
    $l = '';
    if ( $c == 0 )
    {
        $l = 'no category';
    }
    else
    {
        $p = 0;
        foreach( $cats as $cat )
        {
            $l .= '<a href="'.get_category_link($cat->cat_ID).'">'.$cat->cat_name.'</a>, ';
        }
        $l = substr( $l, 0, strlen($l)-2 );
        if ($c > 1)
            $l = substr_replace( $l, " and ", strrpos( $l, ', ' ), 2 );
    }
    echo apply_filters('the_category', $l, ', ', 'single');
}

// if you have Ultimate Tag Warrior installed, this will be used
// to render tags in a format like Tags: tag1, tag2, and tag3
if ( function_exists('UTW_ShowCurrentTagSet') )
{
    function sp_get_tags( )
    {
        global $utw,$post;
        $tags = $utw->GetTagsForPost($post, 0);
        $l = $utw->FormatTags($tags, $utw->GetFormat('commalistwithtaglabel', $format));
        $c = count($tags);
        if ($c > 1)
            $l = substr_replace( $l, " and ", strrpos( $l, ', ' ), 2 );
        echo $l;
    }
}

// renders a menu tab
function sp_menu_tab( $caption, $link, $conditions='' )
{
    $class = '';
    $conditions = explode("&", $conditions);
    $ct = count($conditions);
    if ( $ct > 0 )
    {
        foreach( $conditions as $condition )
        {
            $condition = explode("=", $condition, 2);
            $condition[0] = trim($condition[0]);
            if (function_exists($condition[0]) && $condition[0]($condition[1]))
            {
                $class = " class=\"selmenu\"";
                break;
            }
        }
    }
    else
    {
        $id = '';
    }
    $t = "<li><a href=\"$link\"$class>$caption</a></li>";
    echo $t;
}

// renders the navigation links with some formatting
function sp_nav_links( )
{
    $t = '<div id="navigation">';
    if ( is_single( ) )
    {
        $next = get_next_post( );
        $prev = get_previous_post( );
        if ( $next && $prev )
        {
            $t .= '<a href="'.get_permalink($prev->ID).'">Previous Entry</a> &bull; ';
            $t .= '<a href="'.get_permalink($next->ID).'">Next Entry</a>';
        }
        elseif( $next )
        {
            $t .= '<a href="'.get_permalink($next->ID).'">Next</a>';
        }
        elseif( $prev )
        {
            $t .= '<a href="'.get_permalink($prev->ID).'">Previous</a>';
        }
        else
        {
            return;
        }
    }
    else
    {
        // mostly ripped from WP source, pretty much
        global $wp_query;

        $max_num_pages = $wp_query->max_num_pages;
        $paged = get_query_var('paged');
        if ($max_num_pages < 2)
            return;

        $next = sp_next_posts( $max_page );
        $prev = sp_previous_posts( );
        if ( $next && $prev )
        {
            $t .= "<a href=\"$next\">Previous Entries</a> &bull <a href=\"$prev\">Next Entries</a>";
        }
        elseif( $next )
        {
            $t .= "<a href=\"$next\">Previous Entries</a>";
        }
        elseif( $prev )
        {
            $t .= "<a href=\"$prev\">Next Entries</a>";
        }
        else
        {
            return;
        }
    }
    $t .= '</div>';
    echo $t;
}

// function from WordPress, modified to return info instead of echoing it
function sp_next_posts($max_page = 0) { // original by cfactor at cooltux.org
    global $paged, $pagenow;

    if ( !is_single() ) {
        if ( !$paged )
            $paged = 1;
        $nextpage = intval($paged) + 1;
        if ( !$max_page || $max_page >= $nextpage )
            return get_pagenum_link($nextpage);
    }
    return 0;
}

// function from WordPress, modified to return info instead of echoing it
function sp_previous_posts() { // original by cfactor at cooltux.org
    global $paged, $pagenow;

    if ( !is_single() ) {
        $nextpage = intval($paged) - 1;
        if ( $nextpage < 1 )
            return '';
        return get_pagenum_link($nextpage);
    }
    return 0;
}

/*
 *   $id goes inside <li id="$id"> -- just in case you want a special
 *   sidebar or something.  Or you plan on using that fancy 'ajax'
 *   stuff.  $id is optional.
 *   $head is usually <h2>Your Title</h2> and any other info.  $head
 *   is optional, but it's recommended that you specify one.
 *
 *   To add a sidebar, call sp_sidebar_open( '', '<h2>Caption</h2>' )
 *   id and head are optional, but specifying head in specific is
 *   recommended for organizational purposes.
 *   Once the sidebar is open, simply render out content as normal,
 *   then call sp_sidebar_close( ) [or do a </div></li> -- whatever
 *   you prefer].
 */

$_sp_sidebar_is_open = false;
function sp_sidebar( $id='', $head='' )
{
    global $_sp_sidebar_is_open;
    if ( $_sp_sidebar_is_open )
        sp_sidebar_close( );
    else
        sp_siebar_open( $id, $head );
}

// opens a sidebar with the id as $id and the header text as $head (<h2>/</h2> are not automatic)
function sp_sidebar_open( $id='', $head='' )
{
    global $_sp_sidebar_is_open;
    if ($_sp_sidebar_is_open)
        return;
    $_sp_sidebar_is_open = true;
    if ($id !== '')
        $id = " id=\"$id\"";
    echo "<li$id><div class=\"sidebar-head\">$head</div><div class=\"sidebar-content\">";

}

// closes a sidebar
function sp_sidebar_close( )
{
    global $_sp_sidebar_is_open;
    if (!$_sp_sidebar_is_open)
        return;
    $_sp_sidebar_is_open = false;
    echo "</div></li>";
}

// widget support
if ( function_exists( 'register_sidebar' ) )
{
    register_sidebar( array(
    'before_widget'=>'<li id="%1$s" class="%2$s">',
    'after_widget'=>'</div></li>',
    'before_title'=>'<div class="sidebar-head"><h2>',
    'after_title'=>'</h2></div><div class="sidebar-content">'
    ) );
    
    function sp_widget_search( $args )
    {
    	extract($args);
        echo $before_widget;
            echo $before_title;
                echo "Search";
            echo $after_title;
            ?>
			<form id="searchform" method="get" action="<?php bloginfo('home'); ?>">
			<div>
			<input type="text" name="s" id="s" size="21" /><br />
			<input type="submit" value="<?php _e('Search'); ?>" />
			</div>
			</form>
		<?php
        echo $after_widget;
    }

    register_sidebar_widget('Search', 'sp_widget_search');
} // widget support

// Renders the comment form.  Handy if you decide to move the comment form.
function sp_comment_form( )
{
    global $post, $user_ID, $user_identity;
    
    $url = get_option('siteurl');
    if (get_option('require_name_email'))
        $required = ' (required)';

    sp_entry_open( 'comments', '<a id="respond"></a><h2>Submit Comment</h2>' );

    if ( $post->comment_status == 'open' )
    {
        if ( get_option( 'comment_registration' ) && !$user_ID )
        {
            ?>
            <p>Sorry, but you have to <a href="<?php echo $url; ?>/wp-login.php?redirect_to=<?php the_permalink(); ?>">log in</a> to submit comments.</p>
            <?php
        }
        else
        {
            ?>
            <form action="<?php echo $url; ?>/wp-comments-post.php" method="post" id="commentform">
            <?php
            if ( $user_ID != 0 )
            {
                echo "<p>Logged in as <a href=\"$url/wp-admin/profile.php\">$user_identity</a>.</p>";
            }
            else
            {
                ?>
                <p><input id="author" name="author" type="text" value="<?php echo $comment_author; ?>" tabindex="1" size="24"/>
                <label for="author">Your name</label><?php echo $required; ?></p>
                <p><input id="email" name="email" type="text" value="<?php echo $comment_author_email; ?>" tabindex="2" size="24"/>
                <label for="email">Your e-mail</label><?php echo $required; ?> (This will <em>not</em> be published)</p>
                <p><input id="url" name="url" type="text" value="<?php echo $comment_author_url; ?>" tabindex="3" size="24"/>
                <label for="url">Your website</label></p>
                <?php
            }
            ?>
            <p><textarea id="comment" name="comment" cols="77%" rows="8" tabindex="4"></textarea></p>
            <p><?php do_action('comment_form', $post->ID); ?>
            <input type="submit" name="submit" id="submit" value="Submit"/>
            <input type="hidden" name="comment_post_ID" value="<?php the_ID(); ?>" /></p>
            </form>
            <?php
        }
    }
    else
    {
        ?>
        <p>Sorry, but commenting on this post is disabled.</p>
        <?php
    }

    sp_entry_close( '' );
}



/* theming stuff */

/*

// Removed due to the wordpress theme site being evil in the way it processes stylesheets

function sp_get_skins( )
{
    // based on the get_themes function
    $sproot = get_template_directory( );
    $spdir = @dir( $sproot );
    
    $skins = array();

    if ( $spdir )
    {
        while ( ($skinfile = $spdir->read()) !== false )
        {
            if ( $skinfile == '.' || $skinfile == '..' )
                continue;

            if ( is_dir( "$sproot/$skinfile" ) )
            {
                $style = "$sproot/$skinfile/style.css";
                if ( is_file( $style ) )
                {
                    unset($skin);
                    $skin->skin_path = $style;
                    $data = get_theme_data( $style );
                    $skin->skin_name = $data['Name'];
                    $skin->skin_dir = $skinfile;
                    $skin->skin_author = $data['Author'];
                    $skin->skin_description = wptexturize($data['Description']);
                    $skin->preview = get_bloginfo('template_directory')."/$skinfile/screenshot.png";

                    $skins[$skin->skin_dir] = $skin;
                }
            }
        }
    }
    return $skins;
}

function sp_admin_page( )
{
    if ( isset( $_GET['action'] ) )
    {
        $action = $_GET['action'];
        if ( $action == 'sp_activate_skin' && isset( $_GET['skin'] ) )
        {
            update_option( 'sp_active_theme', $_GET['skin'] );
            ?>
            <div class="updated fade" id="message"><p><strong>Skin changed</strong></p></div>
            <?php
        }
    }

    ?>
    <div class="wrap">
        <?php

        $skins = sp_get_skins( );
        $selected = get_option('sp_active_theme');
        $selected_skin = null;
        foreach( $skins as $skin )
        {
            if ( $selected === $skin->skin_dir )
            {
                $selected_skin = $skin;
                $skins[$skin->skin_dir] = null;
                break;
            }
        }

        ?>
        <h2>Current Skin</h2>
        <div id="currenttheme">
        <img src="<?php echo $selected_skin->preview; ?>" alt="Current skin preview" />
        <h3><?php echo $selected_skin->skin_name; ?> by <?php echo $selected_skin->skin_author; ?></h3>
        <p><?php echo $selected_skin->skin_description; ?></p>
        </div>

        <?php
        if ( count( $skins ) > 0 )
        {
            ?> <h2>Available Skins</h2> <?php
            foreach( $skins as $skin )
            {
                $activate = wp_nonce_url( "themes.php?page=".basename(__FILE__)."&amp;action=sp_activate_skin&amp;skin=$skin->skin_dir" );
                ?>
                <div class="available-theme">
                <h3><a href="<?php echo $activate; ?>"><?php echo $skin->skin_name; ?></a></h3>
                <a href="<?php echo $activate; ?>"><img src="<?php echo $skin->preview; ?>" alt="" /></a>
                <p><?php echo $skin->skin_description; ?></p>
                </div>
                <?php
            }
        }
        ?>
    <div style="clear:both;"></div>
    </div>
    <?php
}

function sp_admin_menu( )
{
    add_theme_page('Theme Skins', 'Theme Skins', 'edit_themes', basename(__FILE__), 'sp_admin_page');
}

add_action( 'admin_menu', 'sp_admin_menu' );
add_option( 'sp_active_theme', 'default', 'The theme to use for skinning the Spiffty template.', 'yes' );

*/

?>
