<?php get_header(); ?>

	<?php if (have_posts()) : ?>
		<?php while (have_posts()) : the_post(); ?>
			<div class="post">
				<h2 class="post-title" id="post-<?php the_ID(); ?>"><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php _e('Permanent link to'); ?> <?php the_title(); ?>"><?php the_title(); ?></a></h2>
				<p class="postmeta"><?php the_time('F j, Y') ?> <?php _e('at'); ?> <?php the_time() ?> &#183; <?php _e('Filed under'); ?> <?php the_category(', ') ?><?php edit_post_link(__('Edit'), ' &#183; ', ''); ?></p>
				<?php if (is_search()) { ?>
					<?php the_excerpt() ?>
				<?php } else { ?>
					<?php the_content(__('Read the rest of this entry &raquo;')); ?>
				<?php } ?>

				<p class="comments-link"><?php comments_popup_link(__('Comments'), __('Comments (1)'), __('Comments (%)'), 'commentslink', __('Comments off')); ?></p>
			</div>
		<?php endwhile; ?>

		<div class="navigation">
			<div class="alignleft"><?php next_posts_link('&laquo; Previous Entries') ?></div>
			<div class="alignright"><?php previous_posts_link('Next Entries &raquo;') ?></div>
		</div>
				
	<?php else : ?>
	<div class="notfound">
		<h2><?php _e('Not Found'); ?></h2>
		<p><?php _e('Sorry, but the page you requested cannot be found.'); ?></p>
		<h3><?php _e('Search'); ?></h3>
		<?php include (TEMPLATEPATH . '/searchform.php'); ?>
	</div>
	<?php endif; ?>

<?php get_sidebar(); ?>

<?php comments_template(); ?>

<?php get_footer(); ?>


