<?php get_header(); ?>
<div id="container">
	<div id="content" class="narrow">
		<?php if (is_category()) { ?>
			<h3 align="center">The following posts are tagged with <?php single_cat_title(''); ?>.</h3><br />
		<?php } elseif ( is_day() || is_month() || is_year() ) { ?>
			<h3 align="center">You are currently looking through the archives.</h3><br />
		<?php } if (is_search()) { ?>
			<h3 align="center">Your search for <font color="#ff0000"><?php echo wp_specialchars($s, 1); ?></font> returned these results. If you cannot find what you 
			are looking for, try looking through the archives.</h3><br />
		<?php } ?>
		<?php if (have_posts()) : ?>
			<?php while (have_posts()) : the_post(); ?>
				<div class="post" id="post-<?php the_ID(); ?>">
					<h1><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php the_title(); ?></a></h1>
					<p class="postmetadata">by <?php the_author() ?> on <?php the_time('F jS, Y') ?>
					<?php if(is_home()) { ?>
						 | <?php comments_popup_link('No Comments &#187;', '1 Comment &#187;', '% Comments &#187;'); ?>
					<?php } ?>
					</p>		
					<div class="entry">
						<?php if (is_search() || is_archive()) { the_excerpt(); } else { the_content('Read the rest of this entry &raquo;'); } ?>
					</div><!-- entry -->
					<?php if (is_home()) { ?>
						<p class="tags"><?php edit_post_link('Edit', '', ' | '); ?>Tags: <?php the_category(', ') ?></p>
					<?php } ?>
				</div><!-- post -->
			<?php endwhile; ?>
			<?php if (is_search() || is_archive()) { ?>
				<div id="navigate">
					<p class="left"><?php next_posts_link('&laquo; Previous Entries') ?></p>
					<p class="right"><?php previous_posts_link('Next Entries &raquo;') ?></p>
				</div>
			<?php } ?>
			<?php else : ?>
				<br /><br />
				<h3 align="center">You are looking for something that does not exist.  Please return 
					<a href="<?php bloginfo('url'); ?>" title="Home" style="color:#666666;">Home</a>.
				</h3>
			<?php endif; ?>
	</div><!-- content -->
	<?php get_sidebar(); ?>
</div><!-- container -->
<?php get_footer(); ?>