<?php get_header(); ?>

<div class="wide-post">

	<h1 class="title">
		<?php if (is_category()): ?>
			Archive for the &#8216;<?php single_cat_title(); ?>&#8217; Category
		<?php elseif (is_day()): ?>
			Archive for <?php the_time('F jS, Y'); ?>
		<?php elseif (is_month()): ?>
			Archive for <?php the_time('F, Y'); ?>
		<?php elseif (is_year()): ?>
			Archive for <?php the_time('Y'); ?>
		<?php elseif (is_author()): ?>
			Author Archive
		<?php elseif (isset($_GET['paged']) && !empty($_GET['paged'])): ?>
			Blog Archives
		<?php endif; ?>
	</h1>
	
	<div class="entry">

		<?php if (have_posts()): $post = $posts[0]; ?>
		
			<ul id="posts">
				<?php while (have_posts()): the_post(); ?>
					<li>
						<h2 class="posttitle">
							<a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>">
								<?php the_title(); ?>
							</a>
						</h2>
						<p class="byline"><small><?php the_time('l, F jS, Y') ?></small></p>
						<?php the_excerpt(); ?>
					</li>
				<?php endwhile; ?>
			</ul>
	
			<div class="navigation">
				<div class="alignleft"><?php next_posts_link('&laquo; Previous Entries') ?></div>
				<div class="alignright"><?php previous_posts_link('Next Entries &raquo;') ?></div>
			</div>

		<?php else : ?>

			<h1 class="title">Not Found</h1>
			<div class="entry">
				<p>Sorry, but you are looking for something that isn't here.</p>
			</div>

		<?php endif; ?>

	</div>
	<div class="bottom"></div>	
</div>
<div>&nbsp;</div>

<?php get_sidebar(); ?>

<?php get_footer(); ?>
