<?php get_header(); ?>

<!-- start post -->
<div class="wide-post">

	<?php if (have_posts()): the_post(); ?>
	
		<h1 id="post-<?php the_ID(); ?>" class="title"><?php the_title(); ?></h1>
		
		<div class="entry">
		
			<?php the_content('<p class="serif">Read the rest of this entry &raquo;</p>'); ?>
			<?php wp_link_pages(array('before' => '<p><strong>Pages:</strong> ', 'after' => '</p>', 'next_or_number' => 'number')); ?>
		
			<p>&nbsp;</p>
			
			<p class="meta">
				<small>
					This entry was posted on <?php the_time('l, F jS, Y'); ?>at <?php the_time(); ?>
					and is filed under <?php the_category(', '); ?>.
					You can follow any responses to this entry through the <?php comments_rss_link('RSS 2.0'); ?> feed.
					<?php if (('open' == $post-> comment_status) && ('open' == $post->ping_status)): ?>
						You can <a href="#respond">leave a response</a> 
						or <a href="<?php trackback_url(true); ?>" rel="trackback">trackback</a> from your own site.
					<?php elseif (!('open' == $post-> comment_status) && ('open' == $post->ping_status)): ?>
						Responses are currently closed, but you can 
						<a href="<?php trackback_url(true); ?> " rel="trackback">trackback</a> from your own site.
					<?php elseif (('open' == $post-> comment_status) && !('open' == $post->ping_status)): ?>
						You can skip to the end and leave a response. Pinging is currently not allowed.
					<?php elseif (!('open' == $post-> comment_status) && !('open' == $post->ping_status)): ?>
						Both comments and pings are currently closed.
					<?php endif; ?>
					
					<?php edit_post_link('Edit this entry.','',''); ?>
				</small>
			</p>

		</div>
	
	<?php else : ?>
	
		<h1 class="title">Not Found</h1>
		<div class="entry">
			<p>Sorry, but you are looking for something that isn't here.</p>
		</div>
	
	<?php endif; ?>
	
	<div class="bottom"></div>
</div>
<!-- end post -->
<div>&nbsp;</div>

<?php comments_template(); ?>

<?php get_sidebar(); ?>

<?php get_footer(); ?>
