<?php

function my_get_recent_posts($current_id, $limit)
{
	global $wpdb;
    $posts = $wpdb->get_results("SELECT ID, post_title FROM " . $wpdb->posts . " WHERE post_status='publish' ORDER BY post_date DESC LIMIT " . $limit);
    foreach ($posts as $post) {
    	$post_title = stripslashes($post->post_title);
        $permalink  = get_permalink($post->ID);
        if ($post->ID != $current_id) echo "<li><a href=\"" . $permalink . "\">" . $post_title . "</a></li>\n";
    }
}

function my_get_pages()
{
	global $wpdb;
    $query =   "SELECT 		ID, post_title, post_name, post_content
				FROM 		" . $wpdb->posts . "
				WHERE 		post_status='static'
				ORDER BY 	menu_order ASC";
	return $wpdb->get_results($query);
}

function my_excluded_pages()
{
	$pages = my_get_pages(the_ID());
	$exclude = "";
	if ($pages) {
		foreach ($pages as $page) {
			$page_id = $page->ID;
   			$page_name = $page->post_name;
   			if ($page_name == "archives" || $page_name == "about"  || $page_name == "about_quick" || $page_name == "contact") {
   				$exclude .= ", ".$page_id;
   			}
   		}
   		$exclude = preg_replace("/^, (.*?)/","\\1",$exclude);
   	}
   	return $exclude;
}
