<?php 
get_header();
?>

<div id="maincol"><!-- The main content column begins  -->
<div class="col">


<?php preg_match('#FROM (.*) GROUP BY#', $request, $matches); /* CHECK SEARCH RESULTS */
$fromwhere = $matches[1];
$numposts = $wpdb->get_var("SELECT COUNT(DISTINCT ID) FROM $fromwhere");

if (0 < $numposts) $numposts = number_format($numposts); ?>

<?php 
	$asides_cat = get_option('tnsasidescat');
	$asides_loc = get_option('tnsasidesloc');
?>

<?php if (is_search()) { /* SEARCH HEADER */ ?>
	<h2>
	<?php if ($numposts==1) { ?>
      	<?php printf(__('found %1$s matching post '), $numposts, 'edit.php'); ?>
	<?php } else { ?>
      	<?php printf(__('found %1$s matching posts '), $numposts, 'edit.php'); ?>
	<?php } ?>
	for '<?php echo $s; ?>'</h2><br />
<?php } ?>

<?php if (is_category()) { /* CATEGORY HEADING */ ?>				
		<h2>all posts in the '<?php echo single_cat_title(); ?>' category</h2><br />

<?php } elseif (is_day()) { /* DAILY HEADING */ ?>
		<h2>all posts on <?php the_time('F jS, Y'); ?></h2><br />

<?php } elseif (is_month()) { /* MONTHLY HEADING */ ?>
		<h2>all posts from <?php the_time('F Y'); ?></h2><br />
<?php } ?>

<?php if (is_home() && $asides_cat != 0 && $asides_loc == 0) { /* if we are on the home page and asides are enabled */ ?>
	<div class="section-header">latest</div>
<?php } ?>

<?php if (is_home() && $asides_cat != 0 && $asides_loc == 0) { /* if separated asides are enabled */
		$asidesCategory = '&cat=-' . $asides_cat;
	} else {
	 	$asidesCategory = '';
	} ?>

<?php if (have_posts()) : query_posts($query_string . $asidesCategory); while (have_posts()) : the_post(); /* start the loop */ ?>

	<?php if ($asides_loc == 1 && $asides_cat != 0 && in_category($asides_cat)) { /* if inline asides are enabled display formatted aside */ ?>
		
		<div class="entry">
			<div class="aside" id="post-<?php the_ID(); ?>">
                  	<span class="aside-colored">
					<?php echo '  &raquo;  '; ?>
					<span class="aside-title"><?php the_title() ?></span>
					<span class="aside-date">
						[<?php the_time('m-d-y'); ?>]
					</span><?php echo '&nbsp;'; ?>
					
                  	</span>
				<span class="aside-text">
					<?php echo wptexturize($post->post_content); echo '&nbsp;'; ?>
					<strong>-<?php the_author(); echo '&nbsp;'; ?></strong>
					<img src="<?php bloginfo('template_url'); ?>/images/comments.gif" title="comments" alt="*"/>
					<span class="aside-comment"><?php comments_popup_link(' (0)',' (1)',' (%)'); ?></span>
				</span>
			</div>
		</div><br />

	<?php } else { /* display normal post formatting */ ?>

		<div class="entry">
			<div class="entrymeta">
				<?php the_time('F jS, Y') ?>
			</div>
			<h3 class="entrytitle" id="post-<?php the_ID(); ?>">
				<a href="<?php the_permalink() ?>" rel="bookmark" title="Permalink to '<?php the_title(); ?>'"><?php the_title(); ?></a>
			</h3>
			
			<div class="entrybody">
                                <?php if (is_search() || is_archive()) {
                                      the_excerpt();
                                } else {
				      	the_content("Read the rest of '" . the_title('', '', false) . "' &raquo;"); ?>
					
                               	<div class="meta-footer">
							<?php _e('Posted in '); ?><?php the_category(',') ?><?php _e(' | '); ?>
							<img src="<?php bloginfo('template_url'); ?>/images/comments.gif" alt="*" title="comments" />
							<?php comments_popup_link(' add a comment',' 1 comment',' % comments'); ?>
							
							<!-- start ajax comment links  -->
							<?php if (get_option('tnsajaxcomments') == 1) { ?>

								<?php 
									$throbberURL = get_option('tnsajaxthrobberurl');
									$commentpageURL = get_option('tnsajaxcommentsurl');
								?>

								<?php $comment_count = get_comments_count(); ?>
								<?php if ($comment_count == '1') { ?>
									<span id="show-inline-comments-<?php the_ID(); ?>"> | 
										<a href="javascript:;" id="show-inline-comments-link-<?php the_ID(); ?>" onmouseup="ajaxShowComments(<?php the_ID(); ?>, '<?php echo $throbberURL; ?>', '<?php echo $commentpageURL; ?>'); return false;">show comment &raquo;</a> 
									</span>
									<span id="hide-inline-comments-<?php the_ID(); ?>" style="display: none;"> | 
										<a href="#comments-<?php the_ID(); ?>" onmouseup="ajaxHideComments(<?php the_ID(); ?>, '<?php echo $throbberURL; ?>', '<?php echo $commentpageURL; ?>'); return true;">&laquo; hide comment</a> 
									</span>
								<?php } else if ($comment_count > '1') {?>
									<span id="show-inline-comments-<?php the_ID(); ?>"> | 
										<a href="javascript:;" id="show-inline-comments-link-<?php the_ID(); ?>" onmouseup="ajaxShowComments(<?php the_ID(); ?>, '<?php echo $throbberURL; ?>', '<?php echo $commentpageURL; ?>'); return false;">show comments &raquo;</a> 
									</span>
									<span id="hide-inline-comments-<?php the_ID(); ?>" style="display: none;"> | 
										<a href="#comments-<?php the_ID(); ?>" onmouseup="ajaxHideComments(<?php the_ID(); ?>, '<?php echo $throbberURL; ?>', '<?php echo $commentpageURL; ?>'); return true;">&laquo; hide comments</a> 
									</span>
								<?php } ?>

							<?php } ?>
							<!-- end ajax comment links -->

					 	</div>
						<!-- start ajax display -->
						<?php if (get_option('tnsajaxcomments') == 1) { ?>
							<div id="ajax-comments-notification-<?php the_ID(); ?>">
							</div>
							<div id="ajax-comments-<?php the_ID(); ?>" class="ajax-comments">
							</div>
						<?php } ?>
						<!-- end ajax display -->
					<?php } ?>
			</div>  	
		</div>
	<?php } ?>

	<!--
	<?php trackback_rdf(); ?>
	-->

	<?php comments_template(); // Get wp-comments.php template ?>

	<?php endwhile; else: ?>
	<p><?php _e('Sorry, no articles matched your criteria.'); ?></p>

<?php endif; ?>

<?php if (is_home() && $asides_cat != 0 && $asides_loc == 0) { /* if we are on the home page and separated asides are enabled */ ?>

	<?php $asides_name = $wpdb->get_var("SELECT cat_name from $wpdb->categories WHERE cat_ID = $asides_cat"); ?>
	<?php $asides_num = get_option('tnsasidesnum'); ?>

	<?php $my_query = new WP_Query('category_name='. $asides_name . '&showposts=' . $asides_num); /* select asides category and number of posts to show */ ?>

	<div class="section-header"><a href="<?php bloginfo('url'); ?>/category/<?php echo $asides_name; ?>/" title="View all 'asides'"><?php echo $asides_name; ?></a></div>

	<?php while ($my_query->have_posts()) : $my_query->the_post(); /* start asides loop */ ?>
  
	<div class="entry">
			<div class="aside" id="post-<?php the_ID(); ?>">
                  	<span class="aside-colored">
					<?php echo '  &raquo;  '; ?>
					<span class="aside-title"><?php the_title() ?></span>
					<span class="aside-date">
						[<?php the_time('m-d-y'); ?>]
					</span><?php echo '&nbsp;'; ?>
					
                  	</span>
				<span class="aside-text">
					<?php echo wptexturize($post->post_content); echo '&nbsp;'; ?>
					<strong>-<?php the_author(); echo '&nbsp;'; ?></strong>
					<img src="<?php bloginfo('template_url'); ?>/images/comments.gif" title="comments" alt="*"/>
					<span class="aside-comment"><?php comments_popup_link(' (0)',' (1)',' (%)'); ?></span>
				</span>
			</div>
	</div>	
			
	<!--
	<?php trackback_rdf(); ?>
	-->

	<?php endwhile; ?>
 <?php } ?>

<?php if (!is_home()) { ?>
	<strong><?php posts_nav_link(' &#8212; ', __('&laquo; previous posts'), __('next posts &raquo;')); ?></strong>
<?php } ?>

</div>
</div><!-- The main content column ends  -->
<?php get_sidebar(); ?>
<?php get_footer(); ?>
