<?php get_header (); ?>
<div id="content">
<ul id="tabs">
	<?php wp_list_cats('children=0'); ?>
</ul>
<br style="clear:both" />
<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

<div class="post" id="post-<?php the_ID(); ?>">
	<h2 class="title"><a href="<?php the_permalink() ?>" rel="bookmark"><?php the_title(); ?></a></h2>
	<div class="meta">
		<?php the_time ('M d, Y @ h:i a'); ?> by <?php the_author (); ?>
	</div>
	
	<div class="storycontent">
		<?php the_content(__('more...')); ?>
		<?php wp_link_pages(); ?>
	</div>

		<div class="feedback">
			Posted under <?php the_category (',') ?> 
			<?php edit_post_link(__(' | Edit This')); ?>
			|
			<?php comments_popup_link(__('No Comments'), __('1 Comment'), __('% Comments')); ?>
		</div>
</div>

<div id="comments">
<?php comments_template(); ?>
</div>

<?php endwhile; else: ?>
<p><?php _e('Sorry, no posts matched your criteria.'); ?></p>
<?php endif; ?>

<?php
	if (function_exists ('sd_previous_posts_link')) {
		sd_previous_posts_link ();
		echo "&nbsp;&mdash;&nbsp;";
		sd_next_posts_link ();
	} else {
		posts_nav_link(' &#8212; ', __('&laquo; Previous Page'), __('Next Page &raquo;'));
	}
?>
<br />

</div>

<?php get_sidebar (); ?>

<?php get_footer (); ?>