<?php get_header(); ?>

	<div id="content">

	<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

		<div class="post" id="post-<?php the_ID(); ?>">
			<h2><a href="<?php echo get_permalink() ?>" rel="bookmark" title="Permanent Link: <?php the_title(); ?>"><?php the_title(); ?></a></h2>
            <small>Posted on <?php the_time('F jS, Y') ?> <!-- at <?php the_time() ?>  by <?php the_author() ?> --> <?php edit_post_link('Edit this entry','| <strong>','</strong>'); ?> | <a href="#comments"><?php comments_number('No Comments', 'One Comment', '% Comments' );?></a> &#187; <?php comments_rss_link('RSS feed'); ?></small><br />
			<span class="cats">Categories:</span> <?php the_category(', ') ?>

			<div class="entry">
				<?php the_content('<p class="serif">Read the rest of this entry &raquo;</p>'); ?>

				<?php wp_link_pages(array('before' => '<p><strong>Pages:</strong> ', 'after' => '</p>', 'next_or_number' => 'number')); ?>

			</div>

		</div>
            <p class="postmetadata">
        		<?php if (('open' == $post-> comment_status) && ('open' == $post->ping_status)) {
        			// Both Comments and Pings are open ?>
        			<a href="#respond">Leave a comment</a> | <a href="<?php trackback_url(true); ?>" rel="trackback">Trackback URI</a>

        		<?php } elseif (!('open' == $post-> comment_status) && ('open' == $post->ping_status)) {
        			// Only Pings are Open ?>
        			Comments are closed | <a href="<?php trackback_url(true); ?>" rel="trackback">Trackback URI</a>

        		<?php } elseif (('open' == $post-> comment_status) && !('open' == $post->ping_status)) {
        			// Comments are open, Pings are not ?>
        			<a href="#respond">Leave a comment</a> | Trackback URI is disabled

        		<?php } elseif (!('open' == $post-> comment_status) && !('open' == $post->ping_status)) {
        			// Neither Comments, nor Pings are open ?>
        			Both comments and pings are currently closed.

        		<?php } ?>
            </p>


	<?php comments_template(); ?>

	<?php endwhile; else: ?>

		<p>Sorry, no posts matched your criteria.</p>

<?php endif; ?>

	</div>
<?php get_sidebar(); ?>

<?php get_footer(); ?>
